/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.webapp.plugin.resource;

import jakarta.servlet.ServletContext;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import jakarta.ws.rs.core.UriInfo;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.cibseven.bpm.engine.impl.util.IoUtil;
import org.cibseven.bpm.engine.rest.exception.RestException;
import org.cibseven.bpm.webapp.AppRuntimeDelegate;
import org.cibseven.bpm.webapp.plugin.resource.AbstractAppPluginResource;
import org.cibseven.bpm.webapp.plugin.resource.PluginResourceOverride;
import org.cibseven.bpm.webapp.plugin.resource.RequestInfo;
import org.cibseven.bpm.webapp.plugin.spi.AppPlugin;

public class AbstractAppPluginRootResource<T extends AppPlugin> {
    public static final String MIME_TYPE_TEXT_PLAIN = "text/plain";
    public static final String MIME_TYPE_TEXT_HTML = "text/html";
    public static final String MIME_TYPE_TEXT_CSS = "text/css";
    public static final String MIME_TYPE_TEXT_JAVASCRIPT = "text/javascript";
    @Context
    protected ServletContext servletContext;
    @Context
    protected HttpHeaders headers;
    @Context
    protected UriInfo uriInfo;
    private final String pluginName;
    protected AppRuntimeDelegate<T> runtimeDelegate;
    protected List<String> allowedAssets;

    public AbstractAppPluginRootResource(String pluginName, AppRuntimeDelegate<T> runtimeDelegate) {
        this.pluginName = pluginName;
        this.runtimeDelegate = runtimeDelegate;
        this.allowedAssets = this.getAllowedAssets();
    }

    protected List<String> getAllowedAssets() {
        ArrayList<String> assets = new ArrayList<String>();
        assets.add("app/plugin.js");
        assets.add("app/plugin.css");
        return assets;
    }

    protected <S extends AbstractAppPluginResource<T>> S subResource(S subResource, String engineName) {
        return subResource;
    }

    @GET
    @Path(value="/static/{file:.*}")
    public Response getAsset(@PathParam(value="file") String file) {
        if (!this.allowedAssets.contains(file)) {
            throw new RestException(Response.Status.FORBIDDEN, "Not allowed to load the following file '" + file + "'.");
        }
        T plugin = this.runtimeDelegate.getAppPluginRegistry().getPlugin(this.pluginName);
        if (plugin != null) {
            InputStream assetStream = this.getPluginAssetAsStream((AppPlugin)plugin, file);
            final InputStream filteredStream = this.applyResourceOverrides(file, assetStream);
            if (assetStream != null) {
                String contentType = this.getContentType(file);
                return Response.ok((Object)new StreamingOutput(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void write(OutputStream out) throws IOException, WebApplicationException {
                        try {
                            byte[] buff = new byte[16000];
                            int read = 0;
                            while ((read = filteredStream.read(buff)) > 0) {
                                out.write(buff, 0, read);
                            }
                        }
                        finally {
                            IoUtil.closeSilently((Closeable)filteredStream);
                            IoUtil.closeSilently((Closeable)out);
                        }
                    }
                }, (String)contentType).build();
            }
        }
        throw new RestException(Response.Status.NOT_FOUND, "It was not able to load the following file '" + file + "'.");
    }

    protected InputStream applyResourceOverrides(String file, InputStream assetStream) {
        ArrayList<PluginResourceOverride> resourceOverrides = new ArrayList<PluginResourceOverride>(this.runtimeDelegate.getResourceOverrides());
        for (PluginResourceOverride pluginResourceOverride : resourceOverrides) {
            assetStream = pluginResourceOverride.filterResource(assetStream, new RequestInfo(this.headers, this.servletContext, this.uriInfo));
        }
        return assetStream;
    }

    protected String getContentType(String file) {
        if (file.endsWith(".js")) {
            return MIME_TYPE_TEXT_JAVASCRIPT;
        }
        if (file.endsWith(".html")) {
            return MIME_TYPE_TEXT_HTML;
        }
        if (file.endsWith(".css")) {
            return MIME_TYPE_TEXT_CSS;
        }
        return MIME_TYPE_TEXT_PLAIN;
    }

    protected InputStream getPluginAssetAsStream(AppPlugin plugin, String fileName) {
        String assetDirectory = plugin.getAssetDirectory();
        if (assetDirectory == null) {
            return null;
        }
        InputStream result = this.getWebResourceAsStream(assetDirectory, fileName);
        if (result == null) {
            result = this.getClasspathResourceAsStream(plugin, assetDirectory, fileName);
        }
        return result;
    }

    protected InputStream getWebResourceAsStream(String assetDirectory, String fileName) {
        String resourceName = String.format("/%s/%s", assetDirectory, fileName);
        return this.servletContext.getResourceAsStream(resourceName);
    }

    protected InputStream getClasspathResourceAsStream(AppPlugin plugin, String assetDirectory, String fileName) {
        String resourceName = String.format("%s/%s", assetDirectory, fileName);
        return plugin.getClass().getClassLoader().getResourceAsStream(resourceName);
    }
}

