/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.spin;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.cibseven.spin.Spin;
import org.cibseven.spin.impl.logging.SpinCoreLogger;
import org.cibseven.spin.impl.logging.SpinLogger;
import org.cibseven.spin.json.SpinJsonNode;
import org.cibseven.spin.spi.DataFormat;
import org.cibseven.spin.spi.DataFormatConfigurator;
import org.cibseven.spin.spi.DataFormatProvider;
import org.cibseven.spin.xml.SpinXmlElement;

public class DataFormats {
    private static SpinCoreLogger LOG = SpinLogger.CORE_LOGGER;
    public static String JSON_DATAFORMAT_NAME = "application/json";
    public static String XML_DATAFORMAT_NAME = "application/xml";
    static DataFormats INSTANCE = new DataFormats();
    protected Map<String, DataFormat<?>> availableDataFormats;

    public static DataFormats getInstance() {
        return INSTANCE;
    }

    public static DataFormat<SpinXmlElement> xml() {
        return DataFormats.getDataFormat(XML_DATAFORMAT_NAME);
    }

    public static DataFormat<SpinJsonNode> json() {
        return DataFormats.getDataFormat(JSON_DATAFORMAT_NAME);
    }

    public static DataFormat<? extends Spin<?>> getDataFormat(String dataFormatName) {
        return INSTANCE.getDataFormatByName(dataFormatName);
    }

    public static Set<DataFormat<? extends Spin<?>>> getAvailableDataFormats() {
        return INSTANCE.getAllAvailableDataFormats();
    }

    public Set<DataFormat<? extends Spin<?>>> getAllAvailableDataFormats() {
        this.ensureDataformatsInitialized();
        return new HashSet(this.availableDataFormats.values());
    }

    public DataFormat<? extends Spin<?>> getDataFormatByName(String name) {
        this.ensureDataformatsInitialized();
        return this.availableDataFormats.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void ensureDataformatsInitialized() {
        if (this.availableDataFormats != null) return;
        Class<DataFormats> clazz = DataFormats.class;
        synchronized (DataFormats.class) {
            if (this.availableDataFormats != null) return;
            this.registerDataFormats(null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void registerDataFormats(ClassLoader classloader) {
        this.registerDataFormats(classloader, Collections.EMPTY_LIST, Collections.EMPTY_MAP);
    }

    public void registerDataFormats(ClassLoader classloader, List<DataFormatConfigurator> configurators) {
        this.registerDataFormats(classloader, configurators, Collections.EMPTY_MAP);
    }

    public void registerDataFormats(ClassLoader classloader, List<DataFormatConfigurator> configurators, Map<String, Object> configurationProperties) {
        HashMap dataFormats = new HashMap();
        if (classloader == null) {
            classloader = DataFormats.class.getClassLoader();
        }
        this.registerCustomDataFormats(dataFormats, classloader, configurationProperties);
        this.applyConfigurators(dataFormats, classloader, configurators);
        LOG.logDataFormats(dataFormats.values());
        this.availableDataFormats = dataFormats;
    }

    protected void registerCustomDataFormats(Map<String, DataFormat<?>> dataFormats, ClassLoader classloader) {
        this.registerCustomDataFormats(dataFormats, classloader, Collections.EMPTY_MAP);
    }

    protected void registerCustomDataFormats(Map<String, DataFormat<?>> dataFormats, ClassLoader classloader, Map<String, Object> configurationProperties) {
        ServiceLoader<DataFormatProvider> providerLoader = ServiceLoader.load(DataFormatProvider.class, classloader);
        for (DataFormatProvider provider : providerLoader) {
            LOG.logDataFormatProvider(provider);
            this.registerProvider(dataFormats, provider, configurationProperties);
        }
    }

    protected void registerProvider(Map<String, DataFormat<?>> dataFormats, DataFormatProvider provider) {
        this.registerProvider(dataFormats, provider, Collections.EMPTY_MAP);
    }

    protected void registerProvider(Map<String, DataFormat<?>> dataFormats, DataFormatProvider provider, Map<String, Object> configurationProperties) {
        String dataFormatName = provider.getDataFormatName();
        if (dataFormats.containsKey(dataFormatName)) {
            throw LOG.multipleProvidersForDataformat(dataFormatName);
        }
        DataFormat<?> dataFormatInstance = provider.createInstance(configurationProperties);
        dataFormats.put(dataFormatName, dataFormatInstance);
    }

    protected void applyConfigurators(Map<String, DataFormat<?>> dataFormats, ClassLoader classloader) {
        this.applyConfigurators(dataFormats, classloader, Collections.EMPTY_LIST);
    }

    protected void applyConfigurators(Map<String, DataFormat<?>> dataFormats, ClassLoader classloader, List<DataFormatConfigurator> dataFormatConfigurators) {
        ServiceLoader<DataFormatConfigurator> configuratorLoader = ServiceLoader.load(DataFormatConfigurator.class, classloader);
        for (DataFormatConfigurator configurator : configuratorLoader) {
            LOG.logDataFormatConfigurator(configurator);
            this.applyConfigurator(dataFormats, configurator);
        }
        for (DataFormatConfigurator configurator : dataFormatConfigurators) {
            LOG.logDataFormatConfigurator(configurator);
            this.applyConfigurator(dataFormats, configurator);
        }
    }

    protected void applyConfigurator(Map<String, DataFormat<?>> dataFormats, DataFormatConfigurator configurator) {
        for (DataFormat<?> dataFormat : dataFormats.values()) {
            if (!configurator.getDataFormatClass().isAssignableFrom(dataFormat.getClass())) continue;
            configurator.configure(dataFormat);
        }
    }

    public static void loadDataFormats() {
        DataFormats.loadDataFormats(null);
    }

    public static void loadDataFormats(ClassLoader classloader) {
        INSTANCE.registerDataFormats(classloader);
    }

    public static void loadDataFormats(ClassLoader classloader, List<DataFormatConfigurator> configurators) {
        INSTANCE.registerDataFormats(classloader, configurators);
    }

    public static void loadDataFormats(ClassLoader classloader, Map configurationProperties) {
        INSTANCE.registerDataFormats(classloader, Collections.EMPTY_LIST, configurationProperties);
    }
}

