/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.spin.impl.json.jackson;

import org.cibseven.commons.logging.BaseLogger;
import org.cibseven.spin.impl.logging.SpinLogger;
import org.cibseven.spin.json.SpinJsonDataFormatException;
import org.cibseven.spin.json.SpinJsonException;
import org.cibseven.spin.json.SpinJsonNode;
import org.cibseven.spin.json.SpinJsonPathException;
import org.cibseven.spin.json.SpinJsonPropertyException;
import spinjar.com.fasterxml.jackson.databind.JavaType;
import spinjar.com.fasterxml.jackson.databind.JsonNode;
import spinjar.com.fasterxml.jackson.databind.node.JsonNodeType;

public class JacksonJsonLogger
extends SpinLogger {
    public static final String PROJECT_CODE = "SPIN/JACKSON-JSON";
    public static final JacksonJsonLogger JSON_TREE_LOGGER = (JacksonJsonLogger)BaseLogger.createLogger(JacksonJsonLogger.class, (String)"SPIN/JACKSON-JSON", (String)"org.cibseven.spin.json", (String)"01");

    public SpinJsonDataFormatException unableToParseInput(Exception e) {
        return new SpinJsonDataFormatException(this.exceptionMessage("001", "Unable to parse input into json node", new Object[0]), e);
    }

    public SpinJsonDataFormatException unableToParseValue(String expectedType, JsonNodeType type) {
        return new SpinJsonDataFormatException(this.exceptionMessage("002", "Expected '{}', got '{}'", new Object[]{expectedType, type.toString()}));
    }

    public SpinJsonDataFormatException unableToWriteJsonNode(Exception cause) {
        return new SpinJsonDataFormatException(this.exceptionMessage("003", "Unable to write json node", new Object[0]), cause);
    }

    public SpinJsonException unableToFindProperty(String propertyName) {
        return new SpinJsonPropertyException(this.exceptionMessage("004", "Unable to find '{}'", new Object[]{propertyName}));
    }

    public SpinJsonException unableToCreateNode(String objectType) {
        return new SpinJsonPropertyException(this.exceptionMessage("005", "Unable to create node for object of type '{}'", new Object[]{objectType}));
    }

    public SpinJsonException unableToDeserialize(JsonNode jsonNode, JavaType type, Exception cause) {
        return new SpinJsonException(this.exceptionMessage("006", "Cannot deserialize '{}...' to java type '{}'", new Object[]{jsonNode.toString().substring(0, 10), type}), cause);
    }

    public SpinJsonDataFormatException unableToConstructJavaType(String fromString, Exception cause) {
        return new SpinJsonDataFormatException(this.exceptionMessage("007", "Cannot construct java type from string '{}'", new Object[]{fromString}), cause);
    }

    public SpinJsonDataFormatException unableToDetectCanonicalType(Object parameter) {
        return new SpinJsonDataFormatException(this.exceptionMessage("008", "Cannot detect canonical data type for parameter '{}'", new Object[]{parameter}));
    }

    public SpinJsonDataFormatException unableToMapInput(Object input, Exception cause) {
        return new SpinJsonDataFormatException(this.exceptionMessage("009", "Unable to map object '{}' to json node", new Object[]{input}), cause);
    }

    public SpinJsonException unableToModifyNode(String nodeName) {
        return new SpinJsonException(this.exceptionMessage("010", "Unable to modify node of type '{}'. Node is not a list.", new Object[]{nodeName}));
    }

    public SpinJsonException unableToGetIndex(String nodeName) {
        return new SpinJsonException(this.exceptionMessage("011", "Unable to get index from '{}'. Node is not a list.", new Object[]{nodeName}));
    }

    public IndexOutOfBoundsException indexOutOfBounds(Integer index, Integer size) {
        return new IndexOutOfBoundsException(this.exceptionMessage("012", "Index is out of bound! Index: '{}', Size: '{}'", new Object[]{index, size}));
    }

    public SpinJsonPathException unableToEvaluateJsonPathExpressionOnNode(SpinJsonNode node, Exception cause) {
        return new SpinJsonPathException(this.exceptionMessage("013", "Unable to evaluate JsonPath expression on element '{}'", new Object[]{node.getClass().getName()}), cause);
    }

    public SpinJsonPathException unableToCompileJsonPathExpression(String expression, Exception cause) {
        return new SpinJsonPathException(this.exceptionMessage("014", "Unable to compile '{}'!", new Object[]{expression}), cause);
    }

    public SpinJsonPathException unableToCastJsonPathResultTo(Class<?> castClass, Exception cause) {
        return new SpinJsonPathException(this.exceptionMessage("015", "Unable to cast JsonPath expression to '{}'", new Object[]{castClass.getName()}), cause);
    }

    public SpinJsonPathException invalidJsonPath(Class<?> castClass, Exception cause) {
        return new SpinJsonPathException(this.exceptionMessage("017", "Invalid json path to '{}'", new Object[]{castClass.getName()}), cause);
    }
}

