/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.spin.impl.xml.dom;

import java.util.Iterator;
import org.cibseven.spin.impl.xml.dom.DomXmlNodeIterator;
import org.cibseven.spin.impl.xml.dom.format.DomXmlDataFormat;
import org.cibseven.spin.xml.SpinXmlAttribute;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class DomXmlAttributeMapIterable
implements Iterable<SpinXmlAttribute> {
    protected final Element domElement;
    protected final DomXmlDataFormat dataFormat;
    protected final String namespace;
    protected final boolean validating;

    public DomXmlAttributeMapIterable(Element domElement, DomXmlDataFormat dataFormat) {
        this.domElement = domElement;
        this.dataFormat = dataFormat;
        this.namespace = null;
        this.validating = false;
    }

    public DomXmlAttributeMapIterable(Element domElement, DomXmlDataFormat dataFormat, String namespace) {
        this.domElement = domElement;
        this.dataFormat = dataFormat;
        this.namespace = namespace;
        this.validating = true;
    }

    @Override
    public Iterator<SpinXmlAttribute> iterator() {
        return new DomXmlNodeIterator<SpinXmlAttribute>(){
            private NamedNodeMap attributes;
            {
                this.attributes = DomXmlAttributeMapIterable.this.domElement.getAttributes();
            }

            @Override
            protected int getLength() {
                return this.attributes.getLength();
            }

            @Override
            protected SpinXmlAttribute getCurrent() {
                if (this.attributes != null) {
                    Attr attribute = (Attr)this.attributes.item(this.index);
                    SpinXmlAttribute current = DomXmlAttributeMapIterable.this.dataFormat.createAttributeWrapper(attribute);
                    if (!DomXmlAttributeMapIterable.this.validating || current.hasNamespace(DomXmlAttributeMapIterable.this.namespace)) {
                        return current;
                    }
                }
                return null;
            }
        };
    }
}

