/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.spin.impl.xml.dom.format;

import java.beans.Introspector;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.cibseven.commons.utils.EnsureUtil;
import org.cibseven.spin.DeserializationTypeValidator;
import org.cibseven.spin.SpinRuntimeException;
import org.cibseven.spin.impl.util.SpinReflectUtil;
import org.cibseven.spin.impl.xml.dom.DomXmlLogger;
import org.cibseven.spin.impl.xml.dom.format.DomXmlDataFormat;
import org.cibseven.spin.impl.xml.dom.format.spi.JaxBContextProvider;
import org.cibseven.spin.spi.DataFormatMapper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import spinjar.javax.xml.bind.JAXBElement;
import spinjar.javax.xml.bind.JAXBException;
import spinjar.javax.xml.bind.Marshaller;
import spinjar.javax.xml.bind.Unmarshaller;
import spinjar.javax.xml.bind.annotation.XmlRootElement;

public class DomXmlDataFormatMapper
implements DataFormatMapper {
    protected DomXmlDataFormat dataFormat;
    private static final DomXmlLogger LOG = DomXmlLogger.XML_DOM_LOGGER;

    public DomXmlDataFormatMapper(DomXmlDataFormat format) {
        this.dataFormat = format;
    }

    @Override
    public boolean canMap(Object parameter) {
        return parameter != null;
    }

    @Override
    public String getCanonicalTypeName(Object object) {
        return object.getClass().getName();
    }

    @Override
    public Object mapJavaToInternal(Object parameter) {
        EnsureUtil.ensureNotNull((String)"Parameter", (Object)parameter);
        Class<?> parameterClass = parameter.getClass();
        DOMResult domResult = new DOMResult();
        try {
            boolean isRootElement;
            Marshaller marshaller = this.getMarshaller(parameterClass);
            boolean bl = isRootElement = parameterClass.getAnnotation(XmlRootElement.class) != null;
            if (isRootElement) {
                this.marshalRootElement(parameter, marshaller, domResult);
            } else {
                this.marshalNonRootElement(parameter, marshaller, domResult);
            }
            Node node = domResult.getNode();
            return ((Document)node).getDocumentElement();
        }
        catch (JAXBException e) {
            throw LOG.unableToMapInput(parameter, e);
        }
    }

    protected void marshalRootElement(Object parameter, Marshaller marshaller, DOMResult domResult) throws JAXBException {
        marshaller.marshal(parameter, domResult);
    }

    protected void marshalNonRootElement(Object parameter, Marshaller marshaller, DOMResult domResult) throws JAXBException {
        Class<?> parameterClass = parameter.getClass();
        String simpleName = Introspector.decapitalize(parameterClass.getSimpleName());
        JAXBElement<Object> root = new JAXBElement<Object>(new QName(simpleName), parameterClass, parameter);
        marshaller.marshal(root, domResult);
    }

    @Override
    public <T> T mapInternalToJava(Object parameter, Class<T> javaClass) {
        return this.mapInternalToJava(parameter, javaClass, null);
    }

    @Override
    public <T> T mapInternalToJava(Object parameter, Class<T> javaClass, DeserializationTypeValidator validator) {
        EnsureUtil.ensureNotNull((String)"Parameter", (Object)parameter);
        EnsureUtil.ensureNotNull((String)"Type", javaClass);
        Node xmlNode = (Node)parameter;
        try {
            this.validateType(javaClass, validator);
            Unmarshaller unmarshaller = this.getUnmarshaller(javaClass);
            JAXBElement<T> root = unmarshaller.unmarshal(new DOMSource(xmlNode), javaClass);
            return root.getValue();
        }
        catch (JAXBException e) {
            throw LOG.unableToDeserialize(parameter, javaClass.getCanonicalName(), e);
        }
    }

    protected void validateType(Class<?> type, DeserializationTypeValidator validator) {
        if (validator != null && !type.isPrimitive()) {
            String className;
            Class<?> typeToValidate = type;
            if (type.isArray()) {
                typeToValidate = type.getComponentType();
            }
            if (!validator.validate(className = typeToValidate.getName())) {
                throw new SpinRuntimeException("The class '" + className + "' is not whitelisted for deserialization.");
            }
        }
    }

    @Override
    public <T> T mapInternalToJava(Object parameter, String classIdentifier) {
        return this.mapInternalToJava(parameter, classIdentifier, null);
    }

    @Override
    public <T> T mapInternalToJava(Object parameter, String classIdentifier, DeserializationTypeValidator validator) {
        EnsureUtil.ensureNotNull((String)"Parameter", (Object)parameter);
        EnsureUtil.ensureNotNull((String)"classIdentifier", (Object)classIdentifier);
        try {
            Class<?> javaClass = SpinReflectUtil.loadClass(classIdentifier, this.dataFormat);
            return (T)this.mapInternalToJava(parameter, javaClass, validator);
        }
        catch (Exception e) {
            throw LOG.unableToDeserialize(parameter, classIdentifier, e);
        }
    }

    protected Marshaller getMarshaller(Class<?> parameter) throws JAXBException {
        JaxBContextProvider jaxBContextProvider = this.dataFormat.getJaxBContextProvider();
        return jaxBContextProvider.createMarshaller(parameter);
    }

    protected Unmarshaller getUnmarshaller(Class<?> parameter) throws JAXBException {
        JaxBContextProvider jaxBContextProvider = this.dataFormat.getJaxBContextProvider();
        return jaxBContextProvider.createUnmarshaller(parameter);
    }
}

