/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.spin.scripting;

import java.io.Closeable;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.cibseven.spin.SpinScriptException;
import org.cibseven.spin.impl.logging.SpinCoreLogger;
import org.cibseven.spin.impl.logging.SpinLogger;
import org.cibseven.spin.impl.util.SpinIoUtil;

public class SpinScriptEnv {
    private static final SpinCoreLogger LOG = SpinLogger.CORE_LOGGER;
    private static final String ENV_PATH_TEMPLATE = "script/env/%s/spin.%s";
    public static final Map<String, String> extensions = new HashMap<String, String>();

    public static String getExtension(String language) {
        if ("ecmascript".equals(language = language.toLowerCase())) {
            language = "javascript";
        }
        return extensions.get(language);
    }

    public static String get(String language) {
        String extension;
        if ("ecmascript".equals(language = language.toLowerCase())) {
            language = "javascript";
        }
        if ((extension = extensions.get(language)) == null) {
            return null;
        }
        return SpinScriptEnv.loadScriptEnv(language, extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String loadScriptEnv(String language, String extension) {
        String scriptEnvPath = String.format(ENV_PATH_TEMPLATE, language, extension);
        InputStream envResource = SpinScriptException.class.getClassLoader().getResourceAsStream(scriptEnvPath);
        if (envResource == null) {
            throw LOG.noScriptEnvFoundForLanguage(language, scriptEnvPath);
        }
        try {
            String string = SpinIoUtil.inputStreamAsString((InputStream)envResource);
            return string;
        }
        finally {
            SpinIoUtil.closeSilently((Closeable)envResource);
        }
    }

    static {
        extensions.put("python", "py");
        extensions.put("javascript", "js");
        extensions.put("groovy", "groovy");
        extensions.put("ruby", "rb");
    }
}

