/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.spin.impl.json.jackson.format;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.cibseven.commons.utils.EnsureUtil;
import org.cibseven.spin.DataFormats;
import org.cibseven.spin.impl.json.jackson.JacksonJsonLogger;
import org.cibseven.spin.impl.json.jackson.JacksonJsonNode;
import org.cibseven.spin.impl.json.jackson.format.DefaultJsonJacksonTypeDetector;
import org.cibseven.spin.impl.json.jackson.format.JacksonJsonDataFormatMapper;
import org.cibseven.spin.impl.json.jackson.format.JacksonJsonDataFormatReader;
import org.cibseven.spin.impl.json.jackson.format.JacksonJsonDataFormatWriter;
import org.cibseven.spin.impl.json.jackson.format.ListJacksonJsonTypeDetector;
import org.cibseven.spin.json.SpinJsonNode;
import org.cibseven.spin.spi.DataFormat;
import org.cibseven.spin.spi.TypeDetector;

public class JacksonJsonDataFormat
implements DataFormat<SpinJsonNode> {
    public static final String DATA_FORMAT_NAME = DataFormats.JSON_DATAFORMAT_NAME;
    private static final JacksonJsonLogger LOG = JacksonJsonLogger.JSON_TREE_LOGGER;
    protected ObjectMapper objectMapper;
    protected Configuration jsonPathConfiguration;
    protected List<TypeDetector> typeDetectors;
    protected JacksonJsonDataFormatReader dataFormatReader;
    protected JacksonJsonDataFormatWriter dataFormatWriter;
    protected JacksonJsonDataFormatMapper dataFormatMapper;
    protected final String name;

    public JacksonJsonDataFormat(String name) {
        this(name, new ObjectMapper());
    }

    public JacksonJsonDataFormat(String name, ObjectMapper objectMapper) {
        this(name, objectMapper, new Configuration.ConfigurationBuilder().jsonProvider((JsonProvider)new JacksonJsonProvider(objectMapper)).mappingProvider((MappingProvider)new JacksonMappingProvider(objectMapper)).build());
    }

    public JacksonJsonDataFormat(String name, ObjectMapper objectMapper, Configuration jsonPathConfiguration) {
        this.name = name;
        this.objectMapper = objectMapper;
        this.jsonPathConfiguration = jsonPathConfiguration;
        this.init();
    }

    protected void init() {
        this.initReader();
        this.initWriter();
        this.initMapper();
        this.initTypeDetectors();
    }

    protected void initMapper() {
        this.dataFormatMapper = new JacksonJsonDataFormatMapper(this);
    }

    protected void initWriter() {
        this.dataFormatWriter = new JacksonJsonDataFormatWriter(this);
    }

    protected void initReader() {
        this.dataFormatReader = new JacksonJsonDataFormatReader(this);
    }

    protected void initTypeDetectors() {
        this.typeDetectors = new ArrayList<TypeDetector>();
        this.typeDetectors.add(new ListJacksonJsonTypeDetector());
        this.typeDetectors.add(new DefaultJsonJacksonTypeDetector());
    }

    public String getName() {
        return DATA_FORMAT_NAME;
    }

    public Class<? extends SpinJsonNode> getWrapperType() {
        return JacksonJsonNode.class;
    }

    public SpinJsonNode createWrapperInstance(Object parameter) {
        return new JacksonJsonNode((JsonNode)parameter, this);
    }

    public String getCanonicalTypeName(Object object) {
        EnsureUtil.ensureNotNull((String)"object", (Object)object);
        for (TypeDetector typeDetector : this.typeDetectors) {
            if (!typeDetector.canHandle(object)) continue;
            return typeDetector.detectType(object);
        }
        throw LOG.unableToDetectCanonicalType(object);
    }

    public JavaType constructJavaTypeFromCanonicalString(String canonicalString) {
        try {
            return TypeFactory.defaultInstance().constructFromCanonical(canonicalString);
        }
        catch (IllegalArgumentException e) {
            throw LOG.unableToConstructJavaType(canonicalString, e);
        }
    }

    public void addTypeDetector(TypeDetector typeDetector) {
        this.typeDetectors.add(0, typeDetector);
    }

    public JacksonJsonDataFormatMapper getMapper() {
        return this.dataFormatMapper;
    }

    public JacksonJsonDataFormatReader getReader() {
        return this.dataFormatReader;
    }

    public JacksonJsonDataFormatWriter getWriter() {
        return this.dataFormatWriter;
    }

    public Configuration getJsonPathConfiguration() {
        return this.jsonPathConfiguration;
    }

    public void setJsonPathConfiguration(Configuration jsonPathConfiguration) {
        this.jsonPathConfiguration = jsonPathConfiguration;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public JsonNode createJsonNode(Object parameter) {
        if (parameter instanceof SpinJsonNode) {
            return (JsonNode)((SpinJsonNode)parameter).unwrap();
        }
        if (parameter instanceof String) {
            return this.createJsonNode((String)parameter);
        }
        if (parameter instanceof Integer) {
            return this.createJsonNode((Integer)parameter);
        }
        if (parameter instanceof Boolean) {
            return this.createJsonNode((Boolean)parameter);
        }
        if (parameter instanceof Float) {
            return this.createJsonNode((Float)parameter);
        }
        if (parameter instanceof Long) {
            return this.createJsonNode((Long)parameter);
        }
        if (parameter instanceof Number) {
            return this.createJsonNode(Float.valueOf(((Number)parameter).floatValue()));
        }
        if (parameter instanceof List) {
            return this.createJsonNode((List)parameter);
        }
        if (parameter instanceof Map) {
            return this.createJsonNode((Map)parameter);
        }
        if (parameter == null) {
            return this.createNullJsonNode();
        }
        throw LOG.unableToCreateNode(parameter.getClass().getSimpleName());
    }

    public JsonNode createJsonNode(String parameter) {
        return this.objectMapper.getNodeFactory().textNode(parameter);
    }

    public JsonNode createJsonNode(Integer parameter) {
        return this.objectMapper.getNodeFactory().numberNode(parameter);
    }

    public JsonNode createJsonNode(Float parameter) {
        return this.objectMapper.getNodeFactory().numberNode(parameter);
    }

    public JsonNode createJsonNode(Long parameter) {
        return this.objectMapper.getNodeFactory().numberNode(parameter);
    }

    public JsonNode createJsonNode(Boolean parameter) {
        return this.objectMapper.getNodeFactory().booleanNode(parameter.booleanValue());
    }

    public JsonNode createJsonNode(List<Object> parameter) {
        if (parameter != null) {
            ArrayNode node = this.objectMapper.getNodeFactory().arrayNode();
            for (Object entry : parameter) {
                node.add(this.createJsonNode(entry));
            }
            return node;
        }
        return this.createNullJsonNode();
    }

    public JsonNode createJsonNode(Map<String, Object> parameter) {
        if (parameter != null) {
            ObjectNode node = this.objectMapper.getNodeFactory().objectNode();
            for (Map.Entry<String, Object> entry : parameter.entrySet()) {
                node.set(entry.getKey(), this.createJsonNode(entry.getValue()));
            }
            return node;
        }
        return this.createNullJsonNode();
    }

    public JsonNode createNullJsonNode() {
        return this.objectMapper.getNodeFactory().nullNode();
    }
}

