/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.spin.impl.json.jackson.format;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Writer;
import org.cibseven.spin.impl.json.jackson.JacksonJsonLogger;
import org.cibseven.spin.impl.json.jackson.format.JacksonJsonDataFormat;
import org.cibseven.spin.spi.DataFormatWriter;

public class JacksonJsonDataFormatWriter
implements DataFormatWriter {
    private static final JacksonJsonLogger LOG = JacksonJsonLogger.JSON_TREE_LOGGER;
    protected JacksonJsonDataFormat dataFormat;

    public JacksonJsonDataFormatWriter(JacksonJsonDataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public void writeToWriter(Writer writer, Object input) {
        ObjectMapper objectMapper = this.dataFormat.getObjectMapper();
        JsonFactory factory = objectMapper.getFactory();
        try {
            JsonGenerator generator = factory.createGenerator(writer);
            objectMapper.writeTree(generator, (JsonNode)input);
        }
        catch (IOException e) {
            throw LOG.unableToWriteJsonNode(e);
        }
    }
}

