/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.spin.impl.json.jackson.format;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TypeHelper {
    static boolean bindingsArePresent(Class<?> erasedType, int expectedTypeParametersCount) {
        if (erasedType == null) {
            return false;
        }
        TypeVariable<Class<?>>[] typeParameters = erasedType.getTypeParameters();
        if (typeParameters.length == 0) {
            return false;
        }
        if (typeParameters.length != expectedTypeParametersCount) {
            throw new IllegalArgumentException("Cannot create TypeBindings for class " + erasedType.getName() + " with " + expectedTypeParametersCount + " type parameter: class expects " + typeParameters.length + " type parameters.");
        }
        return true;
    }

    static JavaType constructType(Object value) {
        Map map;
        int size;
        TypeFactory typeFactory = TypeFactory.defaultInstance();
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            int size2 = collection.size();
            if (size2 > 0) {
                Iterator iterator = collection.iterator();
                Object element = null;
                do {
                    element = iterator.next();
                    if (!TypeHelper.bindingsArePresent(value.getClass(), 1) || element == null && size2 != 1) continue;
                    JavaType elementType = TypeHelper.constructType(element);
                    return typeFactory.constructCollectionType(TypeHelper.guessCollectionType(value), elementType);
                } while (iterator.hasNext() && element == null);
            }
        } else if (value instanceof Map && (size = (map = (Map)value).size()) > 0) {
            Set entries = map.entrySet();
            Iterator iterator = entries.iterator();
            Map.Entry entry = null;
            do {
                entry = iterator.next();
                if (!TypeHelper.bindingsArePresent(value.getClass(), 2) || entry.getValue() == null && size != 1) continue;
                JavaType keyType = TypeHelper.constructType(entry.getKey());
                JavaType valueType = TypeHelper.constructType(entry.getValue());
                return typeFactory.constructMapType(Map.class, keyType, valueType);
            } while (iterator.hasNext() && entry.getValue() == null);
            JavaType keyType = TypeHelper.constructType(entry.getKey());
            return typeFactory.constructMapType(Map.class, keyType, TypeFactory.unknownType());
        }
        if (value != null) {
            return typeFactory.constructType(value.getClass());
        }
        return TypeFactory.unknownType();
    }

    static Class<? extends Collection> guessCollectionType(Object value) {
        if (value instanceof Collection) {
            return value.getClass();
        }
        throw new IllegalArgumentException("Could not detect class for " + value + " of type " + value.getClass().getName());
    }
}

