/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.spin.impl.xml.dom;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.cibseven.commons.utils.EnsureUtil;
import org.cibseven.spin.SpinList;
import org.cibseven.spin.impl.SpinListImpl;
import org.cibseven.spin.impl.xml.dom.DomXmlAttributeMapIterable;
import org.cibseven.spin.impl.xml.dom.DomXmlElementIterable;
import org.cibseven.spin.impl.xml.dom.DomXmlLogger;
import org.cibseven.spin.impl.xml.dom.format.DomXmlDataFormat;
import org.cibseven.spin.impl.xml.dom.format.DomXmlDataFormatMapper;
import org.cibseven.spin.impl.xml.dom.query.DomXPathQuery;
import org.cibseven.spin.impl.xml.dom.util.DomXmlEnsure;
import org.cibseven.spin.xml.SpinXPathQuery;
import org.cibseven.spin.xml.SpinXmlAttribute;
import org.cibseven.spin.xml.SpinXmlElement;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DomXmlElement
extends SpinXmlElement {
    private static final DomXmlLogger LOG = DomXmlLogger.XML_DOM_LOGGER;
    protected static Transformer cachedTransformer = null;
    protected static XPathFactory cachedXPathFactory;
    protected final Element domElement;
    protected final DomXmlDataFormat dataFormat;

    public DomXmlElement(Element domElement, DomXmlDataFormat dataFormat) {
        this.domElement = domElement;
        this.dataFormat = dataFormat;
    }

    public String getDataFormatName() {
        return this.dataFormat.getName();
    }

    public Element unwrap() {
        return this.domElement;
    }

    public String name() {
        return this.domElement.getLocalName();
    }

    public String namespace() {
        return this.domElement.getNamespaceURI();
    }

    public String prefix() {
        return this.domElement.getPrefix();
    }

    public boolean hasPrefix(String prefix) {
        String elementPrefix = this.prefix();
        if (elementPrefix == null) {
            return prefix == null;
        }
        return elementPrefix.equals(prefix);
    }

    public boolean hasNamespace(String namespace) {
        String elementNamespace = this.namespace();
        if (elementNamespace == null) {
            return namespace == null;
        }
        return elementNamespace.equals(namespace);
    }

    public SpinXmlAttribute attr(String attributeName) {
        return this.attrNs(null, attributeName);
    }

    public SpinXmlAttribute attrNs(String namespace, String attributeName) {
        EnsureUtil.ensureNotNull((String)"attributeName", (Object)attributeName);
        Attr attributeNode = this.domElement.getAttributeNodeNS(namespace, attributeName);
        if (attributeNode == null) {
            throw LOG.unableToFindAttributeWithNamespaceAndName(namespace, attributeName);
        }
        return this.dataFormat.createAttributeWrapper(attributeNode);
    }

    public boolean hasAttr(String attributeName) {
        return this.hasAttrNs(null, attributeName);
    }

    public boolean hasAttrNs(String namespace, String attributeName) {
        EnsureUtil.ensureNotNull((String)"attributeName", (Object)attributeName);
        return this.domElement.hasAttributeNS(namespace, attributeName);
    }

    public SpinList<SpinXmlAttribute> attrs() {
        return new SpinListImpl((Iterable)new DomXmlAttributeMapIterable(this.domElement, this.dataFormat));
    }

    public SpinList<SpinXmlAttribute> attrs(String namespace) {
        return new SpinListImpl((Iterable)new DomXmlAttributeMapIterable(this.domElement, this.dataFormat, namespace));
    }

    public List<String> attrNames() {
        ArrayList<String> attributeNames = new ArrayList<String>();
        for (SpinXmlAttribute attribute : this.attrs()) {
            attributeNames.add(attribute.name());
        }
        return attributeNames;
    }

    public List<String> attrNames(String namespace) {
        ArrayList<String> attributeNames = new ArrayList<String>();
        for (SpinXmlAttribute attribute : this.attrs(namespace)) {
            attributeNames.add(attribute.name());
        }
        return attributeNames;
    }

    public String textContent() {
        return this.domElement.getTextContent();
    }

    public SpinXmlElement textContent(String textContent) {
        EnsureUtil.ensureNotNull((String)"textContent", (Object)textContent);
        this.domElement.setTextContent(textContent);
        return this;
    }

    public SpinXmlElement childElement(String elementName) {
        return this.childElement(this.namespace(), elementName);
    }

    public SpinXmlElement childElement(String namespace, String elementName) {
        EnsureUtil.ensureNotNull((String)"elementName", (Object)elementName);
        SpinList<SpinXmlElement> childElements = this.childElements(namespace, elementName);
        if (childElements.size() > 1) {
            throw LOG.moreThanOneChildElementFoundForNamespaceAndName(namespace, elementName);
        }
        return (SpinXmlElement)childElements.get(0);
    }

    public SpinList<SpinXmlElement> childElements() {
        return new SpinListImpl((Iterable)new DomXmlElementIterable(this.domElement, this.dataFormat));
    }

    public SpinList<SpinXmlElement> childElements(String elementName) {
        return this.childElements(this.namespace(), elementName);
    }

    public SpinList<SpinXmlElement> childElements(String namespace, String elementName) {
        EnsureUtil.ensureNotNull((String)"elementName", (Object)elementName);
        SpinListImpl childs = new SpinListImpl((Iterable)new DomXmlElementIterable(this.domElement, this.dataFormat, namespace, elementName));
        if (childs.isEmpty()) {
            throw LOG.unableToFindChildElementWithNamespaceAndName(namespace, elementName);
        }
        return childs;
    }

    public SpinXmlElement attr(String attributeName, String value) {
        return this.attrNs(null, attributeName, value);
    }

    public SpinXmlElement attrNs(String namespace, String attributeName, String value) {
        EnsureUtil.ensureNotNull((String)"attributeName", (Object)attributeName);
        EnsureUtil.ensureNotNull((String)"value", (Object)value);
        try {
            this.domElement.setAttributeNS(namespace, attributeName, value);
        }
        catch (DOMException e) {
            throw LOG.unableToSetAttributeInImplementation(this, namespace, attributeName, value, e);
        }
        return this;
    }

    public SpinXmlElement removeAttr(String attributeName) {
        return this.removeAttrNs(null, attributeName);
    }

    public SpinXmlElement removeAttrNs(String namespace, String attributeName) {
        EnsureUtil.ensureNotNull((String)"attributeName", (Object)attributeName);
        this.domElement.removeAttributeNS(namespace, attributeName);
        return this;
    }

    public SpinXmlElement append(SpinXmlElement ... childElements) {
        EnsureUtil.ensureNotNull((String)"childElements", (Object)childElements);
        for (SpinXmlElement childElement : childElements) {
            EnsureUtil.ensureNotNull((String)"childElement", (Object)childElement);
            DomXmlElement spinDomElement = (DomXmlElement)((Object)EnsureUtil.ensureParamInstanceOf((String)"childElement", (Object)childElement, DomXmlElement.class));
            this.adoptElement(spinDomElement);
            try {
                this.domElement.appendChild(spinDomElement.domElement);
            }
            catch (DOMException e) {
                throw LOG.unableToAppendElementInImplementation(this, childElement, e);
            }
        }
        return this;
    }

    public SpinXmlElement append(SpinXmlElement childElement) {
        return this.append(Arrays.asList(childElement));
    }

    public SpinXmlElement append(Collection<SpinXmlElement> childElements) {
        EnsureUtil.ensureNotNull((String)"childElements", childElements);
        return this.append(childElements.toArray(new SpinXmlElement[0]));
    }

    public SpinXmlElement appendBefore(SpinXmlElement childElement, SpinXmlElement existingChildElement) {
        EnsureUtil.ensureNotNull((String)"childElement", (Object)childElement);
        EnsureUtil.ensureNotNull((String)"existingChildElement", (Object)existingChildElement);
        DomXmlElement childDomElement = (DomXmlElement)((Object)EnsureUtil.ensureParamInstanceOf((String)"childElement", (Object)childElement, DomXmlElement.class));
        DomXmlElement existingChildDomElement = (DomXmlElement)((Object)EnsureUtil.ensureParamInstanceOf((String)"existingChildElement", (Object)existingChildElement, DomXmlElement.class));
        DomXmlEnsure.ensureChildElement(this, existingChildDomElement);
        this.adoptElement(childDomElement);
        try {
            this.domElement.insertBefore(childDomElement.domElement, existingChildDomElement.domElement);
        }
        catch (DOMException e) {
            throw LOG.unableToInsertElementInImplementation(this, childElement, e);
        }
        return this;
    }

    public SpinXmlElement appendAfter(SpinXmlElement childElement, SpinXmlElement existingChildElement) {
        EnsureUtil.ensureNotNull((String)"childElement", (Object)childElement);
        EnsureUtil.ensureNotNull((String)"existingChildElement", (Object)existingChildElement);
        DomXmlElement childDomElement = (DomXmlElement)((Object)EnsureUtil.ensureParamInstanceOf((String)"childElement", (Object)childElement, DomXmlElement.class));
        DomXmlElement existingChildDomElement = (DomXmlElement)((Object)EnsureUtil.ensureParamInstanceOf((String)"existingChildElement", (Object)existingChildElement, DomXmlElement.class));
        DomXmlEnsure.ensureChildElement(this, existingChildDomElement);
        this.adoptElement(childDomElement);
        Node nextSibling = existingChildDomElement.domElement.getNextSibling();
        try {
            if (nextSibling != null) {
                this.domElement.insertBefore(childDomElement.domElement, nextSibling);
            } else {
                this.domElement.appendChild(childDomElement.domElement);
            }
        }
        catch (DOMException e) {
            throw LOG.unableToInsertElementInImplementation(this, childElement, e);
        }
        return this;
    }

    public SpinXmlElement remove(SpinXmlElement ... childElements) {
        EnsureUtil.ensureNotNull((String)"childElements", (Object)childElements);
        for (SpinXmlElement childElement : childElements) {
            EnsureUtil.ensureNotNull((String)"childElement", (Object)childElement);
            DomXmlElement child = (DomXmlElement)((Object)EnsureUtil.ensureParamInstanceOf((String)"childElement", (Object)childElement, DomXmlElement.class));
            DomXmlEnsure.ensureChildElement(this, child);
            try {
                this.domElement.removeChild(child.domElement);
            }
            catch (DOMException e) {
                throw LOG.unableToRemoveChildInImplementation(this, childElement, e);
            }
        }
        return this;
    }

    public SpinXmlElement remove(SpinXmlElement childElement) {
        return this.remove(Arrays.asList(childElement));
    }

    public SpinXmlElement remove(Collection<SpinXmlElement> childElements) {
        EnsureUtil.ensureNotNull((String)"childElements", childElements);
        return this.remove(childElements.toArray(new SpinXmlElement[0]));
    }

    public SpinXmlElement replace(SpinXmlElement newElement) {
        EnsureUtil.ensureNotNull((String)"newElement", (Object)newElement);
        DomXmlElement element = (DomXmlElement)((Object)EnsureUtil.ensureParamInstanceOf((String)"newElement", (Object)newElement, DomXmlElement.class));
        this.adoptElement(element);
        Node parentNode = this.domElement.getParentNode();
        if (parentNode == null) {
            throw LOG.elementHasNoParent(this);
        }
        try {
            parentNode.replaceChild(element.domElement, this.domElement);
        }
        catch (DOMException e) {
            throw LOG.unableToReplaceElementInImplementation(this, newElement, e);
        }
        return element;
    }

    public SpinXmlElement replaceChild(SpinXmlElement existingChildElement, SpinXmlElement newChildElement) {
        EnsureUtil.ensureNotNull((String)"existingChildElement", (Object)existingChildElement);
        EnsureUtil.ensureNotNull((String)"newChildElement", (Object)newChildElement);
        DomXmlEnsure.ensureChildElement(this, (DomXmlElement)existingChildElement);
        DomXmlElement existingChild = (DomXmlElement)((Object)EnsureUtil.ensureParamInstanceOf((String)"existingChildElement", (Object)existingChildElement, DomXmlElement.class));
        DomXmlElement newChild = (DomXmlElement)((Object)EnsureUtil.ensureParamInstanceOf((String)"newChildElement", (Object)newChildElement, DomXmlElement.class));
        this.adoptElement(newChild);
        try {
            this.domElement.replaceChild(newChild.domElement, existingChild.domElement);
        }
        catch (DOMException e) {
            throw LOG.unableToReplaceElementInImplementation(existingChild, newChildElement, e);
        }
        return this;
    }

    public SpinXPathQuery xPath(String expression) {
        XPath query = this.getXPathFactory().newXPath();
        return new DomXPathQuery(this, query, expression, this.dataFormat);
    }

    protected void adoptElement(DomXmlElement elementToAdopt) {
        Node node;
        Element element;
        Document document = this.domElement.getOwnerDocument();
        if (!document.equals((element = elementToAdopt.domElement).getOwnerDocument()) && (node = document.adoptNode(element)) == null) {
            throw LOG.unableToAdoptElement(elementToAdopt);
        }
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        this.writeToWriter(writer);
        return writer.toString();
    }

    public void writeToWriter(Writer writer) {
        this.dataFormat.getWriter().writeToWriter(writer, this.domElement);
    }

    protected XPathFactory getXPathFactory() {
        if (cachedXPathFactory == null) {
            cachedXPathFactory = XPathFactory.newInstance();
        }
        return cachedXPathFactory;
    }

    public <C> C mapTo(Class<C> javaClass) {
        DomXmlDataFormatMapper mapper = this.dataFormat.getMapper();
        return (C)mapper.mapInternalToJava(this.domElement, javaClass);
    }

    public <C> C mapTo(String javaClass) {
        DomXmlDataFormatMapper mapper = this.dataFormat.getMapper();
        return (C)mapper.mapInternalToJava(this.domElement, javaClass);
    }
}

