/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.spin.impl.xml.dom.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.cibseven.commons.utils.EnsureUtil;
import org.cibseven.spin.xml.SpinXmlElement;

public class DomXPathNamespaceResolver
implements NamespaceContext {
    protected Map<String, String> namespaces = new HashMap<String, String>();
    protected SpinXmlElement element;

    public DomXPathNamespaceResolver(SpinXmlElement element) {
        this.element = element;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        EnsureUtil.ensureNotNull((String)"Prefix", (Object)prefix);
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (prefix.equals("")) {
            return this.element.namespace();
        }
        if (this.namespaces.containsKey(prefix)) {
            return this.namespaces.get(prefix);
        }
        return "";
    }

    @Override
    public String getPrefix(String namespaceURI) {
        EnsureUtil.ensureNotNull((String)"Namespace URI", (Object)namespaceURI);
        if (namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        if (namespaceURI.equals(this.element.name())) {
            return "";
        }
        String key = null;
        if (this.namespaces.containsValue(namespaceURI)) {
            for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
                if (!namespaceURI.equals(entry.getValue())) continue;
                key = entry.getKey();
                break;
            }
        }
        return key;
    }

    public Iterator getPrefixes(String namespaceURI) {
        EnsureUtil.ensureNotNull((String)"Namespace URI", (Object)namespaceURI);
        ArrayList<String> list = new ArrayList<String>();
        if (namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
            list.add("xml");
            return Collections.unmodifiableList(list).iterator();
        }
        if (namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
            list.add("xmlns");
            return Collections.unmodifiableList(list).iterator();
        }
        if (namespaceURI.equals(this.element.namespace())) {
            list.add("");
        }
        if (this.namespaces.containsValue(namespaceURI)) {
            for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
                if (!namespaceURI.equals(entry.getValue())) continue;
                list.add(entry.getKey());
            }
        }
        return Collections.unmodifiableList(list).iterator();
    }

    public void setNamespace(String prefix, String namespaceURI) {
        EnsureUtil.ensureNotNull((String)"Prefix", (Object)prefix);
        EnsureUtil.ensureNotNull((String)"Namespace URI", (Object)namespaceURI);
        this.namespaces.put(prefix, namespaceURI);
    }

    public void setNamespaces(Map<String, String> namespaces) {
        EnsureUtil.ensureNotNull((String)"Namespaces", namespaces);
        this.namespaces = namespaces;
    }
}

