/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.spin.impl.xml.dom.query;

import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.cibseven.spin.SpinList;
import org.cibseven.spin.impl.SpinListImpl;
import org.cibseven.spin.impl.xml.dom.DomXmlAttributeIterable;
import org.cibseven.spin.impl.xml.dom.DomXmlElement;
import org.cibseven.spin.impl.xml.dom.DomXmlElementIterable;
import org.cibseven.spin.impl.xml.dom.DomXmlLogger;
import org.cibseven.spin.impl.xml.dom.format.DomXmlDataFormat;
import org.cibseven.spin.impl.xml.dom.query.DomXPathNamespaceResolver;
import org.cibseven.spin.impl.xml.dom.util.DomXmlEnsure;
import org.cibseven.spin.xml.SpinXPathQuery;
import org.cibseven.spin.xml.SpinXmlAttribute;
import org.cibseven.spin.xml.SpinXmlElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DomXPathQuery
extends SpinXPathQuery {
    private static final DomXmlLogger LOG = DomXmlLogger.XML_DOM_LOGGER;
    protected final DomXmlElement domElement;
    protected final XPath query;
    protected final String expression;
    protected final DomXmlDataFormat dataFormat;
    protected DomXPathNamespaceResolver resolver;

    public DomXPathQuery(DomXmlElement domElement, XPath query, String expression, DomXmlDataFormat dataFormat) {
        this.domElement = domElement;
        this.query = query;
        this.expression = expression;
        this.dataFormat = dataFormat;
        this.resolver = new DomXPathNamespaceResolver(this.domElement);
        this.query.setNamespaceContext(this.resolver);
    }

    public SpinXmlElement element() {
        try {
            DomXmlEnsure.ensureNotDocumentRootExpression(this.expression);
            Element element = (Element)this.query.evaluate(this.expression, this.domElement.unwrap(), XPathConstants.NODE);
            DomXmlEnsure.ensureXPathNotNull(element, this.expression);
            return this.dataFormat.createElementWrapper(element);
        }
        catch (XPathExpressionException e) {
            throw LOG.unableToEvaluateXPathExpressionOnElement(this.domElement, e);
        }
        catch (ClassCastException e) {
            throw LOG.unableToCastXPathResultTo(Element.class, e);
        }
    }

    public SpinList<SpinXmlElement> elementList() {
        try {
            DomXmlEnsure.ensureNotDocumentRootExpression(this.expression);
            NodeList nodeList = (NodeList)this.query.evaluate(this.expression, this.domElement.unwrap(), XPathConstants.NODESET);
            DomXmlEnsure.ensureXPathNotEmpty(nodeList, this.expression);
            return new SpinListImpl((Iterable)new DomXmlElementIterable(nodeList, this.dataFormat));
        }
        catch (XPathExpressionException e) {
            throw LOG.unableToEvaluateXPathExpressionOnElement(this.domElement, e);
        }
        catch (ClassCastException e) {
            throw LOG.unableToCastXPathResultTo(NodeList.class, e);
        }
    }

    public SpinXmlAttribute attribute() {
        try {
            DomXmlEnsure.ensureNotDocumentRootExpression(this.expression);
            Attr attribute = (Attr)this.query.evaluate(this.expression, this.domElement.unwrap(), XPathConstants.NODE);
            DomXmlEnsure.ensureXPathNotNull(attribute, this.expression);
            return this.dataFormat.createAttributeWrapper(attribute);
        }
        catch (XPathExpressionException e) {
            throw LOG.unableToEvaluateXPathExpressionOnElement(this.domElement, e);
        }
        catch (ClassCastException e) {
            throw LOG.unableToCastXPathResultTo(Attr.class, e);
        }
    }

    public SpinList<SpinXmlAttribute> attributeList() {
        try {
            DomXmlEnsure.ensureNotDocumentRootExpression(this.expression);
            NodeList nodeList = (NodeList)this.query.evaluate(this.expression, this.domElement.unwrap(), XPathConstants.NODESET);
            DomXmlEnsure.ensureXPathNotEmpty(nodeList, this.expression);
            return new SpinListImpl((Iterable)new DomXmlAttributeIterable(nodeList, this.dataFormat));
        }
        catch (XPathExpressionException e) {
            throw LOG.unableToEvaluateXPathExpressionOnElement(this.domElement, e);
        }
        catch (ClassCastException e) {
            throw LOG.unableToCastXPathResultTo(NodeList.class, e);
        }
    }

    public String string() {
        try {
            DomXmlEnsure.ensureNotDocumentRootExpression(this.expression);
            return (String)this.query.evaluate(this.expression, this.domElement.unwrap(), XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            throw LOG.unableToEvaluateXPathExpressionOnElement(this.domElement, e);
        }
        catch (ClassCastException e) {
            throw LOG.unableToCastXPathResultTo(String.class, e);
        }
    }

    public Double number() {
        try {
            DomXmlEnsure.ensureNotDocumentRootExpression(this.expression);
            return (Double)this.query.evaluate(this.expression, this.domElement.unwrap(), XPathConstants.NUMBER);
        }
        catch (XPathExpressionException e) {
            throw LOG.unableToEvaluateXPathExpressionOnElement(this.domElement, e);
        }
        catch (ClassCastException e) {
            throw LOG.unableToCastXPathResultTo(Double.class, e);
        }
    }

    public Boolean bool() {
        try {
            DomXmlEnsure.ensureNotDocumentRootExpression(this.expression);
            return (Boolean)this.query.evaluate(this.expression, this.domElement.unwrap(), XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException e) {
            throw LOG.unableToEvaluateXPathExpressionOnElement(this.domElement, e);
        }
        catch (ClassCastException e) {
            throw LOG.unableToCastXPathResultTo(Boolean.class, e);
        }
    }

    public SpinXPathQuery ns(String prefix, String namespace) {
        this.resolver.setNamespace(prefix, namespace);
        this.query.setNamespaceContext(this.resolver);
        return this;
    }

    public SpinXPathQuery ns(Map<String, String> namespaces) {
        this.resolver.setNamespaces(namespaces);
        this.query.setNamespaceContext(this.resolver);
        return this;
    }
}

