/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.templateengines;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.cibseven.templateengines.FreeMarkerScriptEngine;

public class FreeMarkerScriptEngineFactory
implements ScriptEngineFactory {
    public static final String NAME = "freemarker";
    public static final String VERSION = "2.3.29";
    public static final List<String> names = Collections.unmodifiableList(Arrays.asList("freemarker", "Freemarker", "FreeMarker"));
    public static final List<String> extensions = Collections.unmodifiableList(Collections.singletonList("ftl"));
    public static final List<String> mimeTypes = Collections.emptyList();

    @Override
    public String getEngineName() {
        return NAME;
    }

    @Override
    public String getEngineVersion() {
        return VERSION;
    }

    @Override
    public List<String> getExtensions() {
        return extensions;
    }

    @Override
    public List<String> getMimeTypes() {
        return mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return names;
    }

    @Override
    public String getLanguageName() {
        return NAME;
    }

    @Override
    public String getLanguageVersion() {
        return VERSION;
    }

    @Override
    public Object getParameter(String key) {
        if (key.equals("javax.script.name")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (key.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        if (key.equals("THREADING")) {
            return "MULTITHREADED";
        }
        return null;
    }

    @Override
    public String getMethodCallSyntax(String object, String method, String ... args) {
        return "${" + object + "." + method + "(" + this.joinStrings(", ", args) + ")}";
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        return toDisplay;
    }

    @Override
    public String getProgram(String ... statements) {
        return this.joinStrings("\n", statements);
    }

    protected String joinStrings(String delimiter, String[] values) {
        if (values == null) {
            return null;
        }
        return String.join((CharSequence)delimiter, values);
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new FreeMarkerScriptEngine(this);
    }
}

