/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.webapp.config;

import java.util.Arrays;
import lombok.Generated;
import org.cibseven.webapp.auth.exception.AuthenticationException;
import org.cibseven.webapp.exception.AccessDeniedException;
import org.cibseven.webapp.exception.ApplicationException;
import org.cibseven.webapp.exception.ErrorMessage;
import org.cibseven.webapp.exception.NoObjectFoundException;
import org.cibseven.webapp.rest.BaseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice(assignableTypes={BaseService.class})
@ResponseBody
@Order(value=-2147483648)
public class ExceptionConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExceptionConverter.class);

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ErrorMessage authentication(AuthenticationException x) {
        log.debug("Authentication error occured " + Arrays.toString(x.getData()), (Throwable)x);
        return new ErrorMessage(x.getClass().getSimpleName(), x.getData());
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    public ErrorMessage authentication(AccessDeniedException x) {
        log.error("Access denied", (Throwable)x);
        return new ErrorMessage(x.getClass().getSimpleName(), new Object[]{x.getMessage()});
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ErrorMessage application(ApplicationException x) {
        log.info("Application error occured " + Arrays.toString(x.getData()), (Throwable)x);
        return new ErrorMessage(x.getClass().getSimpleName(), x.getData());
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ErrorMessage system(RuntimeException x) {
        log.error("System error occured", (Throwable)x);
        return new ErrorMessage(x.getClass().getSimpleName(), new Object[]{x.getMessage()});
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ErrorMessage application(NoObjectFoundException x) {
        log.debug("Application error occured " + Arrays.toString(x.getData()), (Throwable)x);
        return new ErrorMessage("NoObjectFoundException");
    }
}

