/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.webapp.config;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.servers.Server;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.cibseven.webapp.rest.model.InfoVersion;
import org.springdoc.core.customizers.OpenApiCustomizer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OpenApiConfig {
    @Value(value="${cibseven.webclient.api.common.url:}")
    String serverUrl;
    @Value(value="${cibseven.webclient.api.common.title:CIB seven webclient API}")
    String apiTitle;
    @Value(value="${cibseven.webclient.api.common.description:This API exposes the functionality of CIB seven webclient as a REST service under the Apache License 2.0.}")
    String apiDescription;
    @Value(value="${cibseven.webclient.api.common.termsOfService:https://www.apache.org/licenses/LICENSE-2.0}")
    String apiTermsOfService;
    @Value(value="${cibseven.webclient.api.common.license:Apache 2.0}")
    String apiLicense;
    @Value(value="${cibseven.webclient.api.common.licenseUrl:https://www.apache.org/licenses/LICENSE-2.0}")
    String apiLicenseUrl;
    @Value(value="${cibseven.webclient.api.common.contact.name:CIB seven}")
    String apiContactName;
    @Value(value="${cibseven.webclient.api.common.contact.url:https://cibseven.org}")
    String apiContactUrl;
    @Value(value="${cibseven.webclient.api.common.contact.email:info@cibseven.org}")
    String apiContactEmail;
    @Autowired
    InfoVersion infoVersion;

    @Bean
    OpenAPI getOpenApiDocumentation() {
        OpenAPI openAPI = new OpenAPI();
        if (this.serverUrl != null && !this.serverUrl.isEmpty()) {
            Server server = new Server();
            server.setUrl(this.serverUrl);
            openAPI.setServers(Arrays.asList(server));
        }
        return openAPI.info(new Info().title(this.apiTitle).description(this.apiDescription).version(this.infoVersion.getVersion()).contact(new Contact().name(this.apiContactName).url(this.apiContactUrl).email(this.apiContactEmail)).termsOfService(this.apiTermsOfService).license(new License().name(this.apiLicense).url(this.apiLicenseUrl)));
    }

    @Bean
    OpenApiCustomizer sortSchemasAlphabetically() {
        return openApi -> {
            Map schemas = openApi.getComponents().getSchemas();
            openApi.getComponents().setSchemas(new TreeMap(schemas));
        };
    }
}

