/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search;

import org.cicirello.search.SolutionCostPair;
import org.cicirello.util.Copyable;

public final class ProgressTracker<T extends Copyable<T>> {
    private volatile int bestCost;
    private volatile double bestCostD;
    private volatile T bestSolution;
    private volatile long when;
    private volatile boolean foundBest;
    private volatile boolean stop;
    private volatile boolean containsIntCost;
    private long origin;
    private final Object lock = new Object();

    public ProgressTracker() {
        this.bestCost = Integer.MAX_VALUE;
        this.bestCostD = Double.POSITIVE_INFINITY;
        this.when = this.origin = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(int cost, T solution, boolean isKnownOptimal) {
        Object object = this.lock;
        synchronized (object) {
            if (this.bestSolution == null || cost < this.bestCost) {
                this.bestCost = cost;
                this.bestCostD = this.bestCost;
                this.bestSolution = solution.copy();
                this.containsIntCost = true;
                this.foundBest = isKnownOptimal;
                this.when = System.nanoTime();
            }
            return this.bestCost;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double update(double cost, T solution, boolean isKnownOptimal) {
        Object object = this.lock;
        synchronized (object) {
            if (this.bestSolution == null || cost < this.bestCostD) {
                this.bestCostD = cost;
                this.bestSolution = solution.copy();
                this.containsIntCost = false;
                this.foundBest = isKnownOptimal;
                this.when = System.nanoTime();
            }
            return this.bestCostD;
        }
    }

    public boolean update(SolutionCostPair<T> pair) {
        if (pair.containsIntCost()) {
            int c = pair.getCost();
            int updatedCost = c < this.bestCost ? this.update(c, pair.getSolution(), pair.containsKnownOptimal()) : this.bestCost;
            return c == updatedCost;
        }
        double c = pair.getCostDouble();
        double updatedCost = c < this.bestCostD ? this.update(c, pair.getSolution(), pair.containsKnownOptimal()) : this.bestCostD;
        return c == updatedCost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolutionCostPair<T> getSolutionCostPair() {
        Object object = this.lock;
        synchronized (object) {
            if (this.containsIntCost) {
                return new SolutionCostPair<T>(this.bestSolution, this.bestCost, this.foundBest);
            }
            return new SolutionCostPair<T>(this.bestSolution, this.bestCostD, this.foundBest);
        }
    }

    public int getCost() {
        return this.bestCost;
    }

    public double getCostDouble() {
        return this.bestCostD;
    }

    public T getSolution() {
        return this.bestSolution;
    }

    public long elapsed() {
        return this.when - this.origin;
    }

    public boolean didFindBest() {
        return this.foundBest;
    }

    public void stop() {
        this.stop = true;
    }

    public void start() {
        this.stop = false;
    }

    public boolean isStopped() {
        return this.stop;
    }

    public boolean containsIntCost() {
        return this.containsIntCost;
    }
}

