/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.concurrent;

import java.util.Collection;
import org.cicirello.search.Metaheuristic;
import org.cicirello.search.concurrent.ParallelMetaheuristic;
import org.cicirello.search.concurrent.ParallelMultistarterUtil;
import org.cicirello.search.restarts.ConstantRestartSchedule;
import org.cicirello.search.restarts.Multistarter;
import org.cicirello.search.restarts.RestartSchedule;
import org.cicirello.util.Copyable;

public final class ParallelMultistarter<T extends Copyable<T>>
extends ParallelMetaheuristic<T> {
    public ParallelMultistarter(Metaheuristic<T> search, int runLength, int numThreads) {
        this(search, new ConstantRestartSchedule(runLength), numThreads);
    }

    public ParallelMultistarter(Metaheuristic<T> search, RestartSchedule r, int numThreads) {
        super(new Multistarter<T>(search, r), numThreads);
    }

    public ParallelMultistarter(Metaheuristic<T> search, Collection<? extends RestartSchedule> schedules) {
        super(ParallelMultistarterUtil.toMultistarters(search, schedules), false);
    }

    public ParallelMultistarter(Collection<? extends Metaheuristic<T>> searches, Collection<? extends RestartSchedule> schedules) {
        super(ParallelMultistarterUtil.toMultistarters(searches, schedules), false);
    }

    public ParallelMultistarter(Collection<? extends Metaheuristic<T>> searches, int runLength) {
        this(searches, ConstantRestartSchedule.createRestartSchedules(searches.size(), runLength));
    }

    public ParallelMultistarter(Multistarter<T> multistartSearch, int numThreads) {
        super(multistartSearch, numThreads);
    }

    public ParallelMultistarter(Collection<? extends Multistarter<T>> multistarters) {
        super(multistarters);
    }

    private ParallelMultistarter(ParallelMultistarter<T> other) {
        super(other);
    }

    @Override
    public ParallelMultistarter<T> split() {
        return new ParallelMultistarter<T>(this);
    }
}

