/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.cicirello.search.Metaheuristic;
import org.cicirello.search.ProgressTracker;
import org.cicirello.search.ReoptimizableMetaheuristic;
import org.cicirello.search.problems.Problem;
import org.cicirello.search.restarts.Multistarter;
import org.cicirello.search.restarts.ReoptimizableMultistarter;
import org.cicirello.search.restarts.RestartSchedule;
import org.cicirello.util.Copyable;

final class ParallelMultistarterUtil {
    private ParallelMultistarterUtil() {
    }

    static <T extends Copyable<T>> Collection<Multistarter<T>> toMultistarters(Metaheuristic<T> search, Collection<? extends RestartSchedule> schedules) {
        if (schedules.size() < 1) {
            throw new IllegalArgumentException("Must pass at least one schedule.");
        }
        ArrayList<Multistarter<T>> restarters = new ArrayList<Multistarter<T>>(schedules.size());
        boolean addedFirst = false;
        for (RestartSchedule restartSchedule : schedules) {
            if (addedFirst) {
                restarters.add(new Multistarter(search.split(), restartSchedule));
                continue;
            }
            restarters.add(new Multistarter<T>(search, restartSchedule));
            addedFirst = true;
        }
        return restarters;
    }

    static <T extends Copyable<T>> Collection<Multistarter<T>> toMultistarters(Collection<? extends Metaheuristic<T>> searches, Collection<? extends RestartSchedule> schedules) {
        if (searches.size() != schedules.size()) {
            throw new IllegalArgumentException("number of searches and number of schedules must be the same");
        }
        ArrayList<Multistarter<T>> restarters = new ArrayList<Multistarter<T>>(searches.size());
        Iterator<? extends RestartSchedule> rs = schedules.iterator();
        ProgressTracker t = null;
        Problem problem = null;
        for (Metaheuristic<T> s : searches) {
            if (problem == null) {
                problem = s.getProblem();
            } else if (s.getProblem() != problem) {
                throw new IllegalArgumentException("All Metaheuristics in searches must solve the same problem.");
            }
            if (t == null) {
                t = s.getProgressTracker();
            } else if (s.getProgressTracker() != t) {
                throw new IllegalArgumentException("All Metaheuristics in searches must share a single ProgressTracker.");
            }
            restarters.add(new Multistarter<T>(s, rs.next()));
        }
        return restarters;
    }

    static <T extends Copyable<T>> Collection<ReoptimizableMultistarter<T>> toReoptimizableMultistarters(ReoptimizableMetaheuristic<T> search, Collection<? extends RestartSchedule> schedules) {
        if (schedules.size() < 1) {
            throw new IllegalArgumentException("Must pass at least one schedule.");
        }
        ArrayList<ReoptimizableMultistarter<T>> restarters = new ArrayList<ReoptimizableMultistarter<T>>(schedules.size());
        boolean addedFirst = false;
        for (RestartSchedule restartSchedule : schedules) {
            if (addedFirst) {
                restarters.add(new ReoptimizableMultistarter(search.split(), restartSchedule));
                continue;
            }
            restarters.add(new ReoptimizableMultistarter<T>(search, restartSchedule));
            addedFirst = true;
        }
        return restarters;
    }

    static <T extends Copyable<T>> Collection<ReoptimizableMultistarter<T>> toReoptimizableMultistarters(Collection<? extends ReoptimizableMetaheuristic<T>> searches, Collection<? extends RestartSchedule> schedules) {
        if (searches.size() != schedules.size()) {
            throw new IllegalArgumentException("number of searches and number of schedules must be the same");
        }
        ArrayList<ReoptimizableMultistarter<T>> restarters = new ArrayList<ReoptimizableMultistarter<T>>(searches.size());
        Iterator<? extends RestartSchedule> rs = schedules.iterator();
        ProgressTracker t = null;
        Problem problem = null;
        for (ReoptimizableMetaheuristic<T> s : searches) {
            if (problem == null) {
                problem = s.getProblem();
            } else if (s.getProblem() != problem) {
                throw new IllegalArgumentException("All Metaheuristics in searches must solve the same problem.");
            }
            if (t == null) {
                t = s.getProgressTracker();
            } else if (s.getProgressTracker() != t) {
                throw new IllegalArgumentException("All Metaheuristics in searches must share a single ProgressTracker.");
            }
            restarters.add(new ReoptimizableMultistarter<T>(s, rs.next()));
        }
        return restarters;
    }
}

