/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.evo;

import org.cicirello.search.ProgressTracker;
import org.cicirello.search.ReoptimizableMetaheuristic;
import org.cicirello.search.SolutionCostPair;
import org.cicirello.search.evo.Population;
import org.cicirello.search.problems.Problem;
import org.cicirello.util.Copyable;

abstract class AbstractEvolutionaryAlgorithm<T extends Copyable<T>>
implements ReoptimizableMetaheuristic<T> {
    private final Population<T> pop;
    private final Problem<T> problem;
    private long numFitnessEvals;

    AbstractEvolutionaryAlgorithm(Population<T> pop, Problem<T> problem) {
        this.pop = pop;
        this.problem = problem;
    }

    AbstractEvolutionaryAlgorithm(AbstractEvolutionaryAlgorithm<T> other) {
        this.pop = other.pop.split();
        this.problem = other.problem;
        this.numFitnessEvals = 0L;
    }

    @Override
    public final SolutionCostPair<T> optimize(int numGenerations) {
        if (this.pop.evolutionIsPaused()) {
            return null;
        }
        this.pop.init();
        this.pop.initOperators(numGenerations);
        this.numFitnessEvals += (long)this.pop.size();
        this.internalOptimize(numGenerations);
        return this.pop.getMostFit();
    }

    @Override
    public final SolutionCostPair<T> reoptimize(int numGenerations) {
        if (this.pop.evolutionIsPaused()) {
            return null;
        }
        this.pop.initOperators(numGenerations);
        this.internalOptimize(numGenerations);
        return this.pop.getMostFit();
    }

    @Override
    public final ProgressTracker<T> getProgressTracker() {
        return this.pop.getProgressTracker();
    }

    @Override
    public final void setProgressTracker(ProgressTracker<T> tracker) {
        this.pop.setProgressTracker(tracker);
    }

    @Override
    public final Problem<T> getProblem() {
        return this.problem;
    }

    @Override
    public long getTotalRunLength() {
        return this.numFitnessEvals;
    }

    private void internalOptimize(int numGenerations) {
        for (int i = 0; i < numGenerations && !this.pop.evolutionIsPaused(); ++i) {
            this.numFitnessEvals += (long)this.oneGeneration(this.pop);
        }
    }

    abstract int oneGeneration(Population<T> var1);

    @Override
    public abstract AbstractEvolutionaryAlgorithm<T> split();
}

