/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.evo;

import org.cicirello.search.evo.BiasedFitnessProportionalSelection;
import org.cicirello.search.evo.BoltzmannBiasFunction;
import org.cicirello.search.evo.ConstantBoltzmannBiasFunction;
import org.cicirello.search.evo.ExponentialCoolingBiasFunction;
import org.cicirello.search.evo.LinearCoolingBiasFunction;
import org.cicirello.search.evo.PopulationFitnessVector;

public final class BoltzmannSelection
extends BiasedFitnessProportionalSelection {
    private final BoltzmannBiasFunction boltzmann;

    public BoltzmannSelection(double t) {
        this(new ConstantBoltzmannBiasFunction(t));
        if (t <= 0.0) {
            throw new IllegalArgumentException("The temperature must be positive.");
        }
    }

    public BoltzmannSelection(double t0, double tMin, double r, boolean linearCooling) {
        this(linearCooling ? new LinearCoolingBiasFunction(t0, r, tMin) : new ExponentialCoolingBiasFunction(t0, r, tMin));
        if (tMin <= 0.0) {
            throw new IllegalArgumentException("Minimum temperature must be positive.");
        }
        if (t0 < tMin) {
            throw new IllegalArgumentException("Minimum temperature must be no greater than initial temperature.");
        }
        if (r <= 0.0) {
            throw new IllegalArgumentException("r must be positive");
        }
        if (!linearCooling && r >= 1.0) {
            throw new IllegalArgumentException("For exponential cooling, r must be positive.");
        }
    }

    private BoltzmannSelection(BoltzmannBiasFunction boltzmann) {
        super(boltzmann);
        this.boltzmann = boltzmann;
    }

    private BoltzmannSelection(BoltzmannSelection other) {
        this(other.boltzmann.split());
    }

    @Override
    public void init(int generations) {
        this.boltzmann.init();
    }

    @Override
    public BoltzmannSelection split() {
        return new BoltzmannSelection(this);
    }

    @Override
    final double[] computeWeightRunningSum(PopulationFitnessVector.Integer fitnesses) {
        double[] result = super.computeWeightRunningSum(fitnesses);
        this.boltzmann.update();
        return result;
    }

    @Override
    final double[] computeWeightRunningSum(PopulationFitnessVector.Double fitnesses) {
        double[] result = super.computeWeightRunningSum(fitnesses);
        this.boltzmann.update();
        return result;
    }
}

