/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.evo;

import org.cicirello.search.evo.BoltzmannBiasFunction;

final class ExponentialCoolingBiasFunction
extends BoltzmannBiasFunction {
    private final double t0;
    private final double r;
    private final double tMin;

    public ExponentialCoolingBiasFunction(double t0, double r, double tMin) {
        super(t0);
        this.t0 = t0;
        this.r = r;
        this.tMin = tMin;
    }

    @Override
    public double getT0() {
        return this.t0;
    }

    @Override
    public double nextT(double t) {
        return (t *= this.r) < this.tMin ? this.tMin : t;
    }

    @Override
    public ExponentialCoolingBiasFunction split() {
        return new ExponentialCoolingBiasFunction(this.t0, this.r, this.tMin);
    }
}

