/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.evo;

import org.cicirello.search.evo.AbstractRouletteWheelSelection;
import org.cicirello.search.evo.PopulationFitnessVector;

public final class ExponentialRankSelection
extends AbstractRouletteWheelSelection {
    private final double c;

    public ExponentialRankSelection(double c) {
        if (c <= 0.0 || c >= 1.0) {
            throw new IllegalArgumentException("c must be int he interval (0.0, 1.0).");
        }
        this.c = c;
    }

    @Override
    public ExponentialRankSelection split() {
        return this;
    }

    @Override
    final double[] computeWeightRunningSum(PopulationFitnessVector.Integer fitnesses) {
        return this.computeWeightRunningSumRanks(this.sortedIndexes(fitnesses), r -> Math.pow(this.c, (double)fitnesses.size() - r - 1.0));
    }

    @Override
    final double[] computeWeightRunningSum(PopulationFitnessVector.Double fitnesses) {
        return this.computeWeightRunningSumRanks(this.sortedIndexes(fitnesses), r -> Math.pow(this.c, (double)fitnesses.size() - r - 1.0));
    }
}

