/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.evo;

import org.cicirello.search.evo.PopulationFitnessVector;
import org.cicirello.search.evo.StochasticUniversalSampling;

public final class ExponentialRankStochasticUniversalSampling
extends StochasticUniversalSampling {
    private final double c;

    public ExponentialRankStochasticUniversalSampling(double c) {
        if (c <= 0.0 || c >= 1.0) {
            throw new IllegalArgumentException("c must be int he interval (0.0, 1.0).");
        }
        this.c = c;
    }

    @Override
    public ExponentialRankStochasticUniversalSampling split() {
        return this;
    }

    @Override
    final double[] computeWeightRunningSum(PopulationFitnessVector.Integer fitnesses) {
        return this.computeWeightRunningSumRanks(this.sortedIndexes(fitnesses), r -> Math.pow(this.c, (double)fitnesses.size() - r - 1.0));
    }

    @Override
    final double[] computeWeightRunningSum(PopulationFitnessVector.Double fitnesses) {
        return this.computeWeightRunningSumRanks(this.sortedIndexes(fitnesses), r -> Math.pow(this.c, (double)fitnesses.size() - r - 1.0));
    }
}

