/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.evo;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.math.rand.RandomVariates;
import org.cicirello.search.ProgressTracker;
import org.cicirello.search.evo.AbstractEvolutionaryAlgorithm;
import org.cicirello.search.evo.BasePopulation;
import org.cicirello.search.evo.FitnessFunction;
import org.cicirello.search.evo.Population;
import org.cicirello.search.evo.SelectionOperator;
import org.cicirello.search.operators.CrossoverOperator;
import org.cicirello.search.operators.Initializer;
import org.cicirello.search.operators.MutationOperator;
import org.cicirello.search.problems.Problem;
import org.cicirello.util.Copyable;

public class GenerationalEvolutionaryAlgorithm<T extends Copyable<T>>
extends AbstractEvolutionaryAlgorithm<T> {
    private final MutationOperator<T> mutation;
    private final double M;
    private final CrossoverOperator<T> crossover;
    private final double C;

    public GenerationalEvolutionaryAlgorithm(int n, MutationOperator<T> mutation, double mutationRate, CrossoverOperator<T> crossover, double crossoverRate, Initializer<T> initializer, FitnessFunction.Double<T> f, SelectionOperator selection, int eliteCount, ProgressTracker<T> tracker) {
        this(new BasePopulation.Double<T>(n, initializer, f, selection, tracker, eliteCount), f.getProblem(), mutation, mutationRate, crossover, crossoverRate);
    }

    public GenerationalEvolutionaryAlgorithm(int n, MutationOperator<T> mutation, double mutationRate, CrossoverOperator<T> crossover, double crossoverRate, Initializer<T> initializer, FitnessFunction.Integer<T> f, SelectionOperator selection, int eliteCount, ProgressTracker<T> tracker) {
        this(new BasePopulation.Integer<T>(n, initializer, f, selection, tracker, eliteCount), f.getProblem(), mutation, mutationRate, crossover, crossoverRate);
    }

    public GenerationalEvolutionaryAlgorithm(int n, MutationOperator<T> mutation, double mutationRate, CrossoverOperator<T> crossover, double crossoverRate, Initializer<T> initializer, FitnessFunction.Double<T> f, SelectionOperator selection, ProgressTracker<T> tracker) {
        this(n, mutation, mutationRate, crossover, crossoverRate, initializer, f, selection, 0, tracker);
    }

    public GenerationalEvolutionaryAlgorithm(int n, MutationOperator<T> mutation, double mutationRate, CrossoverOperator<T> crossover, double crossoverRate, Initializer<T> initializer, FitnessFunction.Integer<T> f, SelectionOperator selection, ProgressTracker<T> tracker) {
        this(n, mutation, mutationRate, crossover, crossoverRate, initializer, f, selection, 0, tracker);
    }

    public GenerationalEvolutionaryAlgorithm(int n, MutationOperator<T> mutation, double mutationRate, CrossoverOperator<T> crossover, double crossoverRate, Initializer<T> initializer, FitnessFunction.Double<T> f, SelectionOperator selection, int eliteCount) {
        this(n, mutation, mutationRate, crossover, crossoverRate, initializer, f, selection, eliteCount, new ProgressTracker());
    }

    public GenerationalEvolutionaryAlgorithm(int n, MutationOperator<T> mutation, double mutationRate, CrossoverOperator<T> crossover, double crossoverRate, Initializer<T> initializer, FitnessFunction.Integer<T> f, SelectionOperator selection, int eliteCount) {
        this(n, mutation, mutationRate, crossover, crossoverRate, initializer, f, selection, eliteCount, new ProgressTracker());
    }

    public GenerationalEvolutionaryAlgorithm(int n, MutationOperator<T> mutation, double mutationRate, CrossoverOperator<T> crossover, double crossoverRate, Initializer<T> initializer, FitnessFunction.Double<T> f, SelectionOperator selection) {
        this(n, mutation, mutationRate, crossover, crossoverRate, initializer, f, selection, new ProgressTracker());
    }

    public GenerationalEvolutionaryAlgorithm(int n, MutationOperator<T> mutation, double mutationRate, CrossoverOperator<T> crossover, double crossoverRate, Initializer<T> initializer, FitnessFunction.Integer<T> f, SelectionOperator selection) {
        this(n, mutation, mutationRate, crossover, crossoverRate, initializer, f, selection, new ProgressTracker());
    }

    private GenerationalEvolutionaryAlgorithm(Population<T> pop, Problem<T> problem, MutationOperator<T> mutation, double mutationRate, CrossoverOperator<T> crossover, double crossoverRate) {
        super(pop, problem);
        if (mutation == null) {
            throw new NullPointerException("mutation must be non-null");
        }
        if (crossover == null) {
            throw new NullPointerException("crossover must be non-null");
        }
        if (mutationRate < 0.0) {
            throw new IllegalArgumentException("mutationRate must not be negative");
        }
        if (crossoverRate < 0.0) {
            throw new IllegalArgumentException("crossoverRate must not be negative");
        }
        this.M = mutationRate < 1.0 ? mutationRate : 1.0;
        this.C = crossoverRate < 1.0 ? crossoverRate : 1.0;
        this.mutation = mutation;
        this.crossover = crossover;
    }

    GenerationalEvolutionaryAlgorithm(GenerationalEvolutionaryAlgorithm<T> other) {
        super(other);
        this.mutation = (MutationOperator)other.mutation.split();
        this.crossover = (CrossoverOperator)other.crossover.split();
        this.M = other.M;
        this.C = other.C;
    }

    @Override
    public GenerationalEvolutionaryAlgorithm<T> split() {
        return new GenerationalEvolutionaryAlgorithm<T>(this);
    }

    @Override
    final int oneGeneration(Population<T> pop) {
        pop.select();
        int count = RandomVariates.nextBinomial((int)(pop.mutableSize() / 2), (double)this.C);
        for (int first = 0; first < count; ++first) {
            int second = first + count;
            this.crossover.cross(pop.get(first), pop.get(second));
            pop.updateFitness(first);
            pop.updateFitness(second);
        }
        if (this.M >= 1.0) {
            int LAMBDA = pop.mutableSize();
            for (j = 0; j < LAMBDA; ++j) {
                this.mutation.mutate(pop.get(j));
                pop.updateFitness(j);
            }
            count = (count << 1) + LAMBDA;
        } else {
            int[] operateOnThese = RandomIndexer.sample((int)pop.mutableSize(), (double)this.M);
            for (j = 0; j < operateOnThese.length; ++j) {
                this.mutation.mutate(pop.get(operateOnThese[j]));
                pop.updateFitness(operateOnThese[j]);
            }
            count = (count << 1) + operateOnThese.length;
        }
        pop.replace();
        return count;
    }
}

