/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.evo;

import org.cicirello.search.evo.FitnessFunction;
import org.cicirello.search.problems.IntegerCostOptimizationProblem;
import org.cicirello.search.problems.OptimizationProblem;
import org.cicirello.search.problems.Problem;
import org.cicirello.util.Copyable;

public final class InverseCostFitnessFunction<T extends Copyable<T>>
implements FitnessFunction.Double<T> {
    private final Problem<T> problem;
    private final double c;
    private final double adjustment;

    public InverseCostFitnessFunction(OptimizationProblem<T> problem) {
        this(problem, 1.0);
    }

    public InverseCostFitnessFunction(IntegerCostOptimizationProblem<T> problem) {
        this(problem, 1.0);
    }

    public InverseCostFitnessFunction(OptimizationProblem<T> problem, double c) {
        if (c <= 0.0) {
            throw new IllegalArgumentException("c must be positive");
        }
        this.adjustment = problem.minCost();
        if (!Double.isFinite(this.adjustment)) {
            throw new IllegalArgumentException("Only supports problems that provide finite cost lower bound via minCost method.");
        }
        this.c = c;
        this.problem = problem;
    }

    public InverseCostFitnessFunction(IntegerCostOptimizationProblem<T> problem, double c) {
        if (c <= 0.0) {
            throw new IllegalArgumentException("c must be positive");
        }
        int m = problem.minCost();
        if (m == Integer.MAX_VALUE || m == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Only supports problems that provide finite cost lower bound via minCost method.");
        }
        this.adjustment = m;
        this.c = c;
        this.problem = problem;
    }

    @Override
    public double fitness(T candidate) {
        return this.c / (this.c + this.problem.costAsDouble(candidate) - this.adjustment);
    }

    @Override
    public Problem<T> getProblem() {
        return this.problem;
    }
}

