/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.evo;

import org.cicirello.search.evo.PopulationFitnessVector;
import org.cicirello.search.evo.StochasticUniversalSampling;

public final class LinearRankStochasticUniversalSampling
extends StochasticUniversalSampling {
    private final double c;

    public LinearRankStochasticUniversalSampling(double c) {
        if (c < 1.0 || c > 2.0) {
            throw new IllegalArgumentException("c must be int he interval [1.0, 2.0].");
        }
        this.c = c;
    }

    @Override
    public LinearRankStochasticUniversalSampling split() {
        return this;
    }

    @Override
    final double[] computeWeightRunningSum(PopulationFitnessVector.Integer fitnesses) {
        return this.computeWeightRunningSumRanks(this.sortedIndexes(fitnesses), r -> 2.0 - this.c + 2.0 * r * (this.c - 1.0) / ((double)fitnesses.size() - 1.0));
    }

    @Override
    final double[] computeWeightRunningSum(PopulationFitnessVector.Double fitnesses) {
        return this.computeWeightRunningSumRanks(this.sortedIndexes(fitnesses), r -> 2.0 - this.c + 2.0 * r * (this.c - 1.0) / ((double)fitnesses.size() - 1.0));
    }
}

