/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.evo;

import org.cicirello.util.Copyable;

abstract class PopulationMember<T extends Copyable<T>> {
    final T candidate;

    private PopulationMember(T candidate) {
        this.candidate = candidate;
    }

    public final T getCandidate() {
        return this.candidate;
    }

    static final class IntegerFitness<T extends Copyable<T>>
    extends PopulationMember<T>
    implements Copyable<IntegerFitness<T>> {
        private int fitness;

        public IntegerFitness(T candidate, int fitness) {
            super(candidate);
            this.fitness = fitness;
        }

        public IntegerFitness<T> copy() {
            return new IntegerFitness<Copyable>(this.candidate.copy(), this.fitness);
        }

        public final int getFitness() {
            return this.fitness;
        }

        public final void setFitness(int fitness) {
            this.fitness = fitness;
        }
    }

    static final class DoubleFitness<T extends Copyable<T>>
    extends PopulationMember<T>
    implements Copyable<DoubleFitness<T>> {
        private double fitness;

        public DoubleFitness(T candidate, double fitness) {
            super(candidate);
            this.fitness = fitness;
        }

        public DoubleFitness<T> copy() {
            return new DoubleFitness<Copyable>(this.candidate.copy(), this.fitness);
        }

        public final double getFitness() {
            return this.fitness;
        }

        public final void setFitness(double fitness) {
            this.fitness = fitness;
        }
    }
}

