/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.evo;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.search.evo.PopulationFitnessVector;
import org.cicirello.search.evo.SelectionOperator;

public final class TruncationSelection
implements SelectionOperator {
    private final int k;

    public TruncationSelection(int k) {
        if (k < 1) {
            throw new IllegalArgumentException();
        }
        this.k = k;
    }

    @Override
    public void select(PopulationFitnessVector.Integer fitnesses, int[] selected) {
        if (this.k < fitnesses.size()) {
            int[] selectFrom = this.initSelectFrom(fitnesses.size());
            int truncateCount = selectFrom.length - this.k;
            this.internalSelect(this.bestFitToRight(fitnesses, selectFrom, 0, selectFrom.length - 1, truncateCount), selected, truncateCount);
        } else {
            this.internalSelect(selected, fitnesses.size());
        }
    }

    @Override
    public void select(PopulationFitnessVector.Double fitnesses, int[] selected) {
        if (this.k < fitnesses.size()) {
            int[] selectFrom = this.initSelectFrom(fitnesses.size());
            int truncateCount = selectFrom.length - this.k;
            this.internalSelect(this.bestFitToRight(fitnesses, selectFrom, 0, selectFrom.length - 1, truncateCount), selected, truncateCount);
        } else {
            this.internalSelect(selected, fitnesses.size());
        }
    }

    @Override
    public TruncationSelection split() {
        return this;
    }

    private void internalSelect(int[] selectFrom, int[] selected, int truncateCount) {
        for (int i = 0; i < selected.length; ++i) {
            selected[i] = selectFrom[truncateCount + RandomIndexer.nextInt((int)this.k)];
        }
    }

    private void internalSelect(int[] selected, int n) {
        for (int i = 0; i < selected.length; ++i) {
            selected[i] = RandomIndexer.nextInt((int)n);
        }
    }

    final int[] initSelectFrom(int n) {
        int[] selectFrom = new int[n];
        for (int i = 0; i < n; ++i) {
            selectFrom[i] = i;
        }
        return selectFrom;
    }

    final int[] bestFitToRight(PopulationFitnessVector.Integer fitnesses, int[] indexes, int first, int last, int truncateCount) {
        if (last > first) {
            int pivot;
            for (pivot = this.partition(fitnesses, indexes, first, last); pivot > truncateCount && fitnesses.getFitness(indexes[pivot]) == fitnesses.getFitness(indexes[pivot - 1]); --pivot) {
            }
            if (pivot < truncateCount) {
                return this.bestFitToRight(fitnesses, indexes, pivot + 1, last, truncateCount);
            }
            if (pivot > truncateCount) {
                return this.bestFitToRight(fitnesses, indexes, first, pivot - 1, truncateCount);
            }
        }
        return indexes;
    }

    final int[] bestFitToRight(PopulationFitnessVector.Double fitnesses, int[] indexes, int first, int last, int truncateCount) {
        if (last > first) {
            int pivot;
            for (pivot = this.partition(fitnesses, indexes, first, last); pivot > truncateCount && fitnesses.getFitness(indexes[pivot]) == fitnesses.getFitness(indexes[pivot - 1]); --pivot) {
            }
            if (pivot < truncateCount) {
                return this.bestFitToRight(fitnesses, indexes, pivot + 1, last, truncateCount);
            }
            if (pivot > truncateCount) {
                return this.bestFitToRight(fitnesses, indexes, first, pivot - 1, truncateCount);
            }
        }
        return indexes;
    }

    private int partition(PopulationFitnessVector.Integer fitnesses, int[] indexes, int first, int last) {
        if (last > first + 1) {
            int m = this.indexOfMedian(fitnesses, indexes, first, last, first + last >> 1);
            int temp = indexes[m];
            indexes[m] = indexes[last];
            indexes[last] = temp;
        }
        int x = fitnesses.getFitness(indexes[last]);
        int i = first - 1;
        for (int j = first; j < last; ++j) {
            if (fitnesses.getFitness(indexes[j]) > x) continue;
            int temp = indexes[++i];
            indexes[i] = indexes[j];
            indexes[j] = temp;
        }
        int temp = indexes[i + 1];
        indexes[i + 1] = indexes[last];
        indexes[last] = temp;
        return i + 1;
    }

    private int partition(PopulationFitnessVector.Double fitnesses, int[] indexes, int first, int last) {
        if (last > first + 1) {
            int m = this.indexOfMedian(fitnesses, indexes, first, last, first + last >> 1);
            int temp = indexes[m];
            indexes[m] = indexes[last];
            indexes[last] = temp;
        }
        double x = fitnesses.getFitness(indexes[last]);
        int i = first - 1;
        for (int j = first; j < last; ++j) {
            if (!(fitnesses.getFitness(indexes[j]) <= x)) continue;
            int temp = indexes[++i];
            indexes[i] = indexes[j];
            indexes[j] = temp;
        }
        int temp = indexes[i + 1];
        indexes[i + 1] = indexes[last];
        indexes[last] = temp;
        return i + 1;
    }

    private int indexOfMedian(PopulationFitnessVector.Integer fitnesses, int[] indexes, int a, int b, int c) {
        if (this.isMedian(fitnesses, indexes, a, b, c)) {
            return c;
        }
        if (this.isMedian(fitnesses, indexes, b, c, a)) {
            return a;
        }
        return b;
    }

    private int indexOfMedian(PopulationFitnessVector.Double fitnesses, int[] indexes, int a, int b, int c) {
        if (this.isMedian(fitnesses, indexes, a, b, c)) {
            return c;
        }
        if (this.isMedian(fitnesses, indexes, b, c, a)) {
            return a;
        }
        return b;
    }

    private boolean isMedian(PopulationFitnessVector.Integer fitnesses, int[] indexes, int other1, int other2, int check) {
        return fitnesses.getFitness(indexes[check]) >= fitnesses.getFitness(indexes[other1]) && fitnesses.getFitness(indexes[check]) <= fitnesses.getFitness(indexes[other2]) || fitnesses.getFitness(indexes[check]) <= fitnesses.getFitness(indexes[other1]) && fitnesses.getFitness(indexes[check]) >= fitnesses.getFitness(indexes[other2]);
    }

    private boolean isMedian(PopulationFitnessVector.Double fitnesses, int[] indexes, int other1, int other2, int check) {
        return fitnesses.getFitness(indexes[check]) >= fitnesses.getFitness(indexes[other1]) && fitnesses.getFitness(indexes[check]) <= fitnesses.getFitness(indexes[other2]) || fitnesses.getFitness(indexes[check]) <= fitnesses.getFitness(indexes[other1]) && fitnesses.getFitness(indexes[check]) >= fitnesses.getFitness(indexes[other2]);
    }
}

