/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.hc;

import org.cicirello.search.ProgressTracker;
import org.cicirello.search.SolutionCostPair;
import org.cicirello.search.hc.AbstractHillClimber;
import org.cicirello.search.operators.Initializer;
import org.cicirello.search.operators.IterableMutationOperator;
import org.cicirello.search.operators.MutationIterator;
import org.cicirello.search.problems.IntegerCostOptimizationProblem;
import org.cicirello.search.problems.OptimizationProblem;
import org.cicirello.util.Copyable;

public final class FirstDescentHillClimber<T extends Copyable<T>>
extends AbstractHillClimber<T> {
    public FirstDescentHillClimber(OptimizationProblem<T> problem, IterableMutationOperator<T> mutation, Initializer<T> initializer, ProgressTracker<T> tracker) {
        super(problem, mutation, initializer, tracker);
    }

    public FirstDescentHillClimber(IntegerCostOptimizationProblem<T> problem, IterableMutationOperator<T> mutation, Initializer<T> initializer, ProgressTracker<T> tracker) {
        super(problem, mutation, initializer, tracker);
    }

    public FirstDescentHillClimber(OptimizationProblem<T> problem, IterableMutationOperator<T> mutation, Initializer<T> initializer) {
        super(problem, mutation, initializer, new ProgressTracker());
    }

    public FirstDescentHillClimber(IntegerCostOptimizationProblem<T> problem, IterableMutationOperator<T> mutation, Initializer<T> initializer) {
        super(problem, mutation, initializer, new ProgressTracker());
    }

    private FirstDescentHillClimber(FirstDescentHillClimber<T> other) {
        super(other);
    }

    @Override
    public FirstDescentHillClimber<T> split() {
        return new FirstDescentHillClimber<T>(this);
    }

    @Override
    AbstractHillClimber.OneClimb<T> initClimberInt() {
        return current -> {
            int currentCost = this.pOptInt.cost(current);
            boolean keepClimbing = true;
            while (keepClimbing) {
                keepClimbing = false;
                MutationIterator iter = this.mutation.iterator(current);
                while (iter.hasNext()) {
                    iter.nextMutant();
                    ++this.neighborCount;
                    int cost = this.pOptInt.cost(current);
                    if (cost >= currentCost) continue;
                    currentCost = cost;
                    keepClimbing = true;
                    break;
                }
                if (keepClimbing) continue;
                iter.rollback();
            }
            boolean isMinCost = this.pOptInt.isMinCost(currentCost);
            if (currentCost < this.tracker.getCost()) {
                this.tracker.update(currentCost, current, isMinCost);
            }
            return new SolutionCostPair<Copyable>(current, currentCost, isMinCost);
        };
    }

    @Override
    AbstractHillClimber.OneClimb<T> initClimberDouble() {
        return current -> {
            double currentCost = this.pOpt.cost(current);
            boolean keepClimbing = true;
            while (keepClimbing) {
                keepClimbing = false;
                MutationIterator iter = this.mutation.iterator(current);
                while (iter.hasNext()) {
                    iter.nextMutant();
                    ++this.neighborCount;
                    double cost = this.pOpt.cost(current);
                    if (!(cost < currentCost)) continue;
                    currentCost = cost;
                    keepClimbing = true;
                    break;
                }
                if (keepClimbing) continue;
                iter.rollback();
            }
            boolean isMinCost = this.pOpt.isMinCost(currentCost);
            if (currentCost < this.tracker.getCostDouble()) {
                this.tracker.update(currentCost, current, isMinCost);
            }
            return new SolutionCostPair<Copyable>(current, currentCost, isMinCost);
        };
    }
}

