/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.hc;

import org.cicirello.search.ProgressTracker;
import org.cicirello.search.SolutionCostPair;
import org.cicirello.search.hc.AbstractHillClimber;
import org.cicirello.search.operators.Initializer;
import org.cicirello.search.operators.IterableMutationOperator;
import org.cicirello.search.operators.MutationIterator;
import org.cicirello.search.problems.IntegerCostOptimizationProblem;
import org.cicirello.search.problems.OptimizationProblem;
import org.cicirello.util.Copyable;

public final class SteepestDescentHillClimber<T extends Copyable<T>>
extends AbstractHillClimber<T> {
    public SteepestDescentHillClimber(OptimizationProblem<T> problem, IterableMutationOperator<T> mutation, Initializer<T> initializer, ProgressTracker<T> tracker) {
        super(problem, mutation, initializer, tracker);
    }

    public SteepestDescentHillClimber(IntegerCostOptimizationProblem<T> problem, IterableMutationOperator<T> mutation, Initializer<T> initializer, ProgressTracker<T> tracker) {
        super(problem, mutation, initializer, tracker);
    }

    public SteepestDescentHillClimber(OptimizationProblem<T> problem, IterableMutationOperator<T> mutation, Initializer<T> initializer) {
        super(problem, mutation, initializer, new ProgressTracker());
    }

    public SteepestDescentHillClimber(IntegerCostOptimizationProblem<T> problem, IterableMutationOperator<T> mutation, Initializer<T> initializer) {
        super(problem, mutation, initializer, new ProgressTracker());
    }

    private SteepestDescentHillClimber(SteepestDescentHillClimber<T> other) {
        super(other);
    }

    @Override
    public SteepestDescentHillClimber<T> split() {
        return new SteepestDescentHillClimber<T>(this);
    }

    @Override
    AbstractHillClimber.OneClimb<T> initClimberInt() {
        return current -> {
            int currentCost = this.pOptInt.cost(current);
            boolean keepClimbing = true;
            while (keepClimbing) {
                MutationIterator iter = this.mutation.iterator(current);
                int bestNeighborCost = currentCost;
                while (iter.hasNext()) {
                    iter.nextMutant();
                    ++this.neighborCount;
                    int cost = this.pOptInt.cost(current);
                    if (cost >= bestNeighborCost) continue;
                    iter.setSavepoint();
                    bestNeighborCost = cost;
                }
                iter.rollback();
                if (bestNeighborCost == currentCost) {
                    keepClimbing = false;
                    continue;
                }
                currentCost = bestNeighborCost;
            }
            boolean isMinCost = this.pOptInt.isMinCost(currentCost);
            if (currentCost < this.tracker.getCost()) {
                this.tracker.update(currentCost, current, isMinCost);
            }
            return new SolutionCostPair<Copyable>(current, currentCost, isMinCost);
        };
    }

    @Override
    AbstractHillClimber.OneClimb<T> initClimberDouble() {
        return current -> {
            double currentCost = this.pOpt.cost(current);
            boolean keepClimbing = true;
            while (keepClimbing) {
                MutationIterator iter = this.mutation.iterator(current);
                double bestNeighborCost = currentCost;
                while (iter.hasNext()) {
                    iter.nextMutant();
                    ++this.neighborCount;
                    double cost = this.pOpt.cost(current);
                    if (!(cost < bestNeighborCost)) continue;
                    iter.setSavepoint();
                    bestNeighborCost = cost;
                }
                iter.rollback();
                if (bestNeighborCost == currentCost) {
                    keepClimbing = false;
                    continue;
                }
                currentCost = bestNeighborCost;
            }
            boolean isMinCost = this.pOpt.isMinCost(currentCost);
            if (currentCost < this.tracker.getCostDouble()) {
                this.tracker.update(currentCost, current, isMinCost);
            }
            return new SolutionCostPair<Copyable>(current, currentCost, isMinCost);
        };
    }
}

