/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.bits;

import org.cicirello.search.operators.UndoableMutationOperator;
import org.cicirello.search.representations.BitVector;

public final class BitFlipMutation
implements UndoableMutationOperator<BitVector> {
    private final double m;
    private BitVector bitMask;

    public BitFlipMutation(double m) {
        if (m <= 0.0 || m >= 1.0) {
            throw new IllegalArgumentException("m constrained by: 0.0 < m < 1.0");
        }
        this.m = m;
    }

    private BitFlipMutation(BitFlipMutation other) {
        this.m = other.m;
    }

    @Override
    public void mutate(BitVector c) {
        this.bitMask = new BitVector(c.length(), this.m);
        c.xor(this.bitMask);
    }

    @Override
    public void undo(BitVector c) {
        if (this.bitMask != null) {
            c.xor(this.bitMask);
        }
    }

    @Override
    public BitFlipMutation split() {
        return new BitFlipMutation(this);
    }
}

