/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.bits;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.search.operators.CrossoverOperator;
import org.cicirello.search.representations.BitVector;

public final class KPointCrossover
implements CrossoverOperator<BitVector> {
    private final int[] indexes;

    public KPointCrossover(int k) {
        if (k < 1) {
            throw new IllegalArgumentException("Must specify at least k=1 cross points");
        }
        this.indexes = new int[k];
    }

    @Override
    public void cross(BitVector c1, BitVector c2) {
        int i;
        RandomIndexer.sample((int)c1.length(), (int)this.indexes.length, (int[])this.indexes);
        this.sort(this.indexes);
        for (i = 1; i < this.indexes.length; i += 2) {
            BitVector.exchangeBits(c1, c2, this.indexes[i - 1], this.indexes[i] - 1);
        }
        if (--i < this.indexes.length) {
            BitVector.exchangeBits(c1, c2, this.indexes[i], c1.length() - 1);
        }
    }

    @Override
    public KPointCrossover split() {
        return new KPointCrossover(this.indexes.length);
    }

    private void sort(int[] indexes) {
        for (int i = 1; i < indexes.length; ++i) {
            int element = indexes[i];
            for (int j = i - 1; j >= 0 && indexes[j] > element; --j) {
                indexes[j + 1] = indexes[j];
            }
            indexes[j + 1] = element;
        }
    }
}

