/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.bits;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.search.operators.CrossoverOperator;
import org.cicirello.search.representations.BitVector;

public final class TwoPointCrossover
implements CrossoverOperator<BitVector> {
    private final int[] indexes = new int[2];

    @Override
    public void cross(BitVector c1, BitVector c2) {
        RandomIndexer.nextIntPair((int)c1.length(), (int[])this.indexes);
        if (this.indexes[1] > this.indexes[0]) {
            BitVector.exchangeBits(c1, c2, this.indexes[0], this.indexes[1] - 1);
        } else {
            BitVector.exchangeBits(c1, c2, this.indexes[1], this.indexes[0] - 1);
        }
    }

    @Override
    public TwoPointCrossover split() {
        return new TwoPointCrossover();
    }
}

