/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.integers;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.search.operators.Initializer;
import org.cicirello.search.representations.SingleInteger;

public class IntegerValueInitializer
implements Initializer<SingleInteger> {
    private final int a;
    private final int b;
    private final int min;
    private final int max;
    private final boolean bounded;

    public IntegerValueInitializer(int a, int b) {
        if (a >= b) {
            throw new IllegalArgumentException("a must be less than b");
        }
        this.a = a;
        this.b = b;
        this.bounded = false;
        this.max = 0;
        this.min = 0;
    }

    public IntegerValueInitializer(int a, int b, int min, int max) {
        if (a >= b) {
            throw new IllegalArgumentException("a must be less than b");
        }
        if (min > max) {
            throw new IllegalArgumentException("min must be less than or equal to max");
        }
        this.a = a <= min ? min : a;
        this.b = b > max + 1 ? max + 1 : b;
        this.min = min;
        this.max = max;
        this.bounded = true;
    }

    @Override
    public final SingleInteger createCandidateSolution() {
        if (this.bounded) {
            return new BoundedInteger(this.a + RandomIndexer.nextInt((int)(this.b - this.a)));
        }
        return new SingleInteger(this.a + RandomIndexer.nextInt((int)(this.b - this.a)));
    }

    @Override
    public IntegerValueInitializer split() {
        return this;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof IntegerValueInitializer)) {
            return false;
        }
        IntegerValueInitializer i = (IntegerValueInitializer)other;
        return this.a == i.a && this.b == i.b && this.min == i.min && this.max == i.max && this.bounded == i.bounded;
    }

    public int hashCode() {
        return 31 * (31 * (31 * (31 * (31 + this.a) + this.b) + this.min) + this.max) + (this.bounded ? 1 : 0);
    }

    private final class BoundedInteger
    extends SingleInteger {
        public BoundedInteger(int x) {
            this.set(x);
        }

        public BoundedInteger(BoundedInteger other) {
            super(other);
        }

        @Override
        public final void set(int x) {
            if (x < IntegerValueInitializer.this.min) {
                super.set(IntegerValueInitializer.this.min);
            } else if (x > IntegerValueInitializer.this.max) {
                super.set(IntegerValueInitializer.this.max);
            } else {
                super.set(x);
            }
        }

        @Override
        public BoundedInteger copy() {
            return new BoundedInteger(this);
        }

        private IntegerValueInitializer getOuterThis() {
            return IntegerValueInitializer.this;
        }

        @Override
        public boolean equals(Object other) {
            if (other == null || !(other instanceof BoundedInteger) || !super.equals(other)) {
                return false;
            }
            BoundedInteger a = (BoundedInteger)other;
            return IntegerValueInitializer.this.min == a.getOuterThis().min && IntegerValueInitializer.this.max == a.getOuterThis().max;
        }

        @Override
        public int hashCode() {
            return 31 * (31 * (31 + super.hashCode()) + IntegerValueInitializer.this.min) + IntegerValueInitializer.this.max;
        }
    }
}

