/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.integers;

import java.util.Arrays;
import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.search.operators.Initializer;
import org.cicirello.search.representations.BoundedIntegerVector;
import org.cicirello.search.representations.IntegerVector;

public class IntegerVectorInitializer
implements Initializer<IntegerVector> {
    private final int[] x;
    private final int[] a;
    private final int[] b;
    private final int[] min;
    private final int[] max;

    public IntegerVectorInitializer(int n, int a, int b) {
        if (a >= b) {
            throw new IllegalArgumentException("a must be less than b");
        }
        this.x = new int[n];
        this.a = new int[]{a};
        this.b = new int[]{b};
        this.max = null;
        this.min = null;
    }

    public IntegerVectorInitializer(int[] a, int[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("lengths of a and b must be identical");
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] < b[i]) continue;
            throw new IllegalArgumentException("a[i] must be less than b[i]");
        }
        this.x = new int[a.length];
        this.a = (int[])a.clone();
        this.b = (int[])b.clone();
        this.max = null;
        this.min = null;
    }

    public IntegerVectorInitializer(int n, int a, int b, int min, int max) {
        if (a >= b) {
            throw new IllegalArgumentException("a must be less than b");
        }
        if (min > max) {
            throw new IllegalArgumentException("min must be less than or equal to max");
        }
        this.x = new int[n];
        this.a = new int[]{a <= min ? min : a};
        this.b = new int[]{b > max + 1 ? max + 1 : b};
        this.min = new int[]{min};
        this.max = new int[]{max};
    }

    public IntegerVectorInitializer(int[] a, int[] b, int min, int max) {
        int i;
        if (a.length != b.length) {
            throw new IllegalArgumentException("lengths of a and b must be identical");
        }
        if (min > max) {
            throw new IllegalArgumentException("min must be less than or equal to max");
        }
        for (i = 0; i < a.length; ++i) {
            if (a[i] < b[i]) continue;
            throw new IllegalArgumentException("a[i] must be less than b[i]");
        }
        this.x = new int[a.length];
        this.a = new int[a.length];
        this.b = new int[b.length];
        for (i = 0; i < a.length; ++i) {
            this.a[i] = a[i] <= min ? min : a[i];
            this.b[i] = b[i] > max + 1 ? max + 1 : b[i];
        }
        this.min = new int[]{min};
        this.max = new int[]{max};
    }

    public IntegerVectorInitializer(int[] a, int[] b, int[] min, int[] max) {
        int i;
        if (a.length != b.length || min.length != max.length || a.length != min.length) {
            throw new IllegalArgumentException("lengths of a, b, min, and max must be identical");
        }
        for (i = 0; i < a.length; ++i) {
            if (a[i] >= b[i]) {
                throw new IllegalArgumentException("a[i] must be less than b[i]");
            }
            if (min[i] <= max[i]) continue;
            throw new IllegalArgumentException("min[i] must be less than or equal to max[i]");
        }
        this.x = new int[a.length];
        this.a = new int[a.length];
        this.b = new int[b.length];
        for (i = 0; i < a.length; ++i) {
            this.a[i] = a[i] <= min[i] ? min[i] : a[i];
            this.b[i] = b[i] > max[i] + 1 ? max[i] + 1 : b[i];
        }
        this.min = (int[])min.clone();
        this.max = (int[])max.clone();
    }

    private IntegerVectorInitializer(IntegerVectorInitializer other) {
        this.min = other.min == null ? null : (int[])other.min.clone();
        this.max = other.max == null ? null : (int[])other.max.clone();
        this.a = (int[])other.a.clone();
        this.b = (int[])other.b.clone();
        this.x = new int[this.a.length];
    }

    @Override
    public final IntegerVector createCandidateSolution() {
        if (this.a.length > 1) {
            for (int i = 0; i < this.x.length; ++i) {
                this.x[i] = this.a[i] + RandomIndexer.nextInt((int)(this.b[i] - this.a[i]));
            }
        } else {
            for (int i = 0; i < this.x.length; ++i) {
                this.x[i] = this.a[0] + RandomIndexer.nextInt((int)(this.b[0] - this.a[0]));
            }
        }
        if (this.min != null) {
            return this.min.length > 1 ? new MultiBoundedIntegerVector(this.x) : new BoundedIntegerVector(this.x, this.min[0], this.max[0]);
        }
        return new IntegerVector(this.x);
    }

    @Override
    public IntegerVectorInitializer split() {
        return new IntegerVectorInitializer(this);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof IntegerVectorInitializer)) {
            return false;
        }
        IntegerVectorInitializer i = (IntegerVectorInitializer)other;
        return (this.min == null && i.min == null || Arrays.equals(this.min, i.min) && Arrays.equals(this.max, i.max)) && Arrays.equals(this.a, i.a) && Arrays.equals(this.b, i.b);
    }

    public int hashCode() {
        int h = 31 * Arrays.hashCode(this.a) + Arrays.hashCode(this.b);
        if (this.min != null) {
            h = 31 * (31 * h + Arrays.hashCode(this.min)) + Arrays.hashCode(this.max);
        }
        return h;
    }

    private final class MultiBoundedIntegerVector
    extends IntegerVector {
        public MultiBoundedIntegerVector(int[] x) {
            super(x.length);
            this.setAll(x);
        }

        public MultiBoundedIntegerVector(MultiBoundedIntegerVector other) {
            super(other);
        }

        @Override
        public final void set(int i, int value) {
            if (value < IntegerVectorInitializer.this.min[i]) {
                super.set(i, IntegerVectorInitializer.this.min[i]);
            } else if (value > IntegerVectorInitializer.this.max[i]) {
                super.set(i, IntegerVectorInitializer.this.max[i]);
            } else {
                super.set(i, value);
            }
        }

        private void setAll(int[] x) {
            for (int i = 0; i < x.length; ++i) {
                super.set(i, x[i]);
            }
        }

        @Override
        public MultiBoundedIntegerVector copy() {
            return new MultiBoundedIntegerVector(this);
        }

        private IntegerVectorInitializer getOuterThis() {
            return IntegerVectorInitializer.this;
        }

        @Override
        public boolean equals(Object other) {
            if (other == null || !(other instanceof MultiBoundedIntegerVector) || !super.equals(other)) {
                return false;
            }
            MultiBoundedIntegerVector b = (MultiBoundedIntegerVector)other;
            return Arrays.equals(IntegerVectorInitializer.this.min, b.getOuterThis().min) && Arrays.equals(IntegerVectorInitializer.this.max, b.getOuterThis().max);
        }

        @Override
        public int hashCode() {
            int hash = 1;
            for (int v : IntegerVectorInitializer.this.min) {
                hash = 31 * hash + v;
            }
            for (int v : IntegerVectorInitializer.this.max) {
                hash = 31 * hash + v;
            }
            int L = this.length();
            for (int i = 0; i < L; ++i) {
                hash = 31 * hash + this.get(i);
            }
            return hash;
        }
    }
}

