/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.integers;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.search.operators.MutationOperator;
import org.cicirello.search.representations.IntegerValued;
import org.cicirello.util.Copyable;

public class UniformMutation<T extends IntegerValued>
implements MutationOperator<T>,
IntegerValued,
Copyable<UniformMutation<T>> {
    private int radius;

    UniformMutation(int radius) {
        this.radius = radius;
    }

    UniformMutation(UniformMutation<T> other) {
        this.radius = other.radius;
    }

    public static <T extends IntegerValued> UniformMutation<T> createUniformMutation(int radius) {
        return new UniformMutation<T>(Math.abs(radius));
    }

    public static <T extends IntegerValued> UniformMutation<T> createUniformMutation(int radius, int k) {
        if (k < 1) {
            throw new IllegalArgumentException("k must be at least 1");
        }
        return new PartialUniformMutation(Math.abs(radius), k);
    }

    public static <T extends IntegerValued> UniformMutation<T> createUniformMutation(int radius, double p) {
        if (p <= 0.0) {
            throw new IllegalArgumentException("p must be positive");
        }
        return p >= 1.0 ? new UniformMutation<T>(Math.abs(radius)) : new PartialUniformMutation(Math.abs(radius), p);
    }

    @Override
    public void mutate(T c) {
        int n = c.length();
        for (int i = 0; i < n; ++i) {
            c.set(i, c.get(i) + RandomIndexer.nextInt((int)(this.radius + this.radius + 1)) - this.radius);
        }
    }

    @Override
    public UniformMutation<T> split() {
        return new UniformMutation<T>(this);
    }

    public UniformMutation<T> copy() {
        return new UniformMutation<T>(this);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof UniformMutation)) {
            return false;
        }
        UniformMutation g = (UniformMutation)other;
        return this.radius == g.radius;
    }

    public int hashCode() {
        return this.radius;
    }

    @Override
    public final int length() {
        return 1;
    }

    @Override
    public final int get(int i) {
        return this.radius;
    }

    @Override
    public final int[] toArray(int[] values) {
        if (values == null || values.length != 1) {
            values = new int[]{this.radius};
        }
        return values;
    }

    @Override
    public final void set(int i, int value) {
        this.radius = value;
    }

    final void internalMutate(T c, int[] old) {
        for (int i = 0; i < old.length; ++i) {
            c.set(i, old[i] + RandomIndexer.nextInt((int)(this.radius + this.radius + 1)) - this.radius);
        }
    }

    final void internalMutate(T c, int old) {
        c.set(0, old + RandomIndexer.nextInt((int)(this.radius + this.radius + 1)) - this.radius);
    }

    final void internalPartialMutation(T c, int[] indexes) {
        for (int j = 0; j < indexes.length; ++j) {
            int i = indexes[j];
            c.set(i, c.get(i) + RandomIndexer.nextInt((int)(this.radius + this.radius + 1)) - this.radius);
        }
    }

    final void internalPartialMutation(T c, int[] indexes, int[] old) {
        for (int j = 0; j < indexes.length; ++j) {
            c.set(indexes[j], old[j] + RandomIndexer.nextInt((int)(this.radius + this.radius + 1)) - this.radius);
        }
    }

    private static final class PartialUniformMutation<T extends IntegerValued>
    extends UniformMutation<T> {
        private final int k;
        private final double p;

        PartialUniformMutation(int radius, int k) {
            super(radius);
            this.k = k;
            this.p = -1.0;
        }

        PartialUniformMutation(int radius, double p) {
            super(radius);
            this.p = p;
            this.k = 0;
        }

        PartialUniformMutation(PartialUniformMutation<T> other) {
            super(other);
            this.k = other.k;
            this.p = other.p;
        }

        @Override
        public void mutate(T c) {
            if (this.k >= c.length()) {
                super.mutate(c);
            } else {
                int[] indexes = this.p < 0.0 ? RandomIndexer.sample((int)c.length(), (int)this.k, (int[])null) : RandomIndexer.sample((int)c.length(), (double)this.p);
                this.internalPartialMutation(c, indexes);
            }
        }

        @Override
        public boolean equals(Object other) {
            if (!super.equals(other) || !(other instanceof PartialUniformMutation)) {
                return false;
            }
            PartialUniformMutation g = (PartialUniformMutation)other;
            return this.k == g.k && this.p == g.p;
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + (this.p < 0.0 ? this.k : Double.hashCode(this.p));
        }

        @Override
        public PartialUniformMutation<T> split() {
            return new PartialUniformMutation<T>(this);
        }

        @Override
        public PartialUniformMutation<T> copy() {
            return new PartialUniformMutation<T>(this);
        }
    }
}

