/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.MutationIterator;

final class AdjacentSwapIterator
implements MutationIterator {
    private boolean rolled;
    private boolean hasMore;
    private final Permutation p;
    private int i;
    private int x;

    AdjacentSwapIterator(Permutation p) {
        this.p = p;
        this.hasMore = p.length() >= 2;
        this.i = -1;
        this.x = -1;
    }

    @Override
    public boolean hasNext() {
        return this.hasMore && !this.rolled;
    }

    @Override
    public void nextMutant() {
        if (!this.hasMore) {
            throw new IllegalStateException("no neighbors left");
        }
        if (this.rolled) {
            throw new IllegalStateException("illegal to call nextMutant after calling rollback");
        }
        if (this.i >= 0) {
            this.p.swap(this.i, this.i + 1);
        }
        ++this.i;
        this.p.swap(this.i, this.i + 1);
        if (this.i == this.p.length() - 2) {
            this.hasMore = false;
        }
    }

    @Override
    public void setSavepoint() {
        this.x = this.i;
    }

    @Override
    public void rollback() {
        if (!this.rolled) {
            this.rolled = true;
            if (this.x < 0) {
                if (this.i >= 0) {
                    this.p.swap(this.i, this.i + 1);
                }
            } else if (this.i != this.x) {
                this.p.swap(this.i, this.i + 1);
                this.p.swap(this.x, this.x + 1);
            }
        }
    }
}

