/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.MutationIterator;

final class BlockInterchangeIterator
implements MutationIterator {
    private boolean rolled;
    private boolean hasMoreInsertions;
    private boolean hasMoreElementSwaps;
    private boolean hasMoreBlocksInserts;
    private boolean hasMoreBlocksSwaps;
    private boolean hasMore;
    private int phase;
    private final Permutation p;
    private int h;
    private int i;
    private int j;
    private int k;
    private int w;
    private int x;
    private int y;
    private int z;
    private int savePhase;
    private int nextS;

    BlockInterchangeIterator(Permutation p) {
        this.p = p;
        this.hasMoreInsertions = p.length() >= 2;
        this.hasMoreElementSwaps = p.length() >= 3;
        this.hasMoreBlocksInserts = p.length() >= 4;
        this.hasMoreBlocksSwaps = p.length() >= 4;
        this.hasMore = this.hasMoreInsertions;
        this.phase = 1;
    }

    @Override
    public boolean hasNext() {
        return this.hasMore && !this.rolled;
    }

    @Override
    public void nextMutant() {
        if (this.rolled) {
            throw new IllegalStateException("illegal to call nextMutant after calling rollback");
        }
        if (this.hasMoreInsertions) {
            this.nextInsertion();
        } else if (this.hasMoreElementSwaps) {
            this.nextSwap();
        } else if (this.hasMoreBlocksInserts) {
            this.nextBlockInsertion();
        } else if (this.hasMoreBlocksSwaps) {
            this.nextBlockSwap();
        } else {
            throw new IllegalStateException("no neighbors left");
        }
    }

    @Override
    public void setSavepoint() {
        this.w = this.h;
        this.x = this.i;
        this.y = this.j;
        this.z = this.k;
        this.savePhase = this.phase;
    }

    @Override
    public void rollback() {
        if (!this.rolled) {
            this.rolled = true;
            switch (this.phase) {
                case 1: {
                    if (this.i == this.j) break;
                    this.p.removeAndInsert(this.i, this.j);
                    break;
                }
                case 2: {
                    this.p.swap(this.i, this.j);
                    break;
                }
                case 3: {
                    this.p.removeAndInsert(this.i, this.k - this.j + 1, this.j);
                    break;
                }
                default: {
                    this.p.swapBlocks(this.h, this.h + this.k - this.j, this.k - this.i + this.h, this.k);
                }
            }
            switch (this.savePhase) {
                case 1: {
                    this.p.removeAndInsert(this.y, this.x);
                    break;
                }
                case 2: {
                    this.p.swap(this.x, this.y);
                    break;
                }
                case 3: {
                    this.p.removeAndInsert(this.y, this.z - this.y + 1, this.x);
                    break;
                }
                case 4: {
                    this.p.swapBlocks(this.w, this.x, this.y, this.z);
                }
            }
        }
    }

    private void nextInsertion() {
        if (this.j >= this.i) {
            ++this.j;
            if (this.j >= this.p.length()) {
                this.p.removeAndInsert(this.i, this.j - 1);
                ++this.i;
                if (this.i >= this.p.length() - 1) {
                    this.i = 2;
                    this.j = 0;
                    this.p.swap(1, 2);
                } else {
                    this.j = this.i + 1;
                }
            }
        } else {
            --this.j;
            if (this.j < 0) {
                this.p.removeAndInsert(this.i, this.j + 1);
                ++this.i;
                this.j = this.i - 2;
                this.p.swap(this.i, this.i - 1);
            }
        }
        this.p.swap(this.i, this.j);
        if (this.p.length() <= 2 || this.j == 0 && this.i == this.p.length() - 1) {
            this.hasMoreInsertions = false;
            this.hasMore = this.hasMoreElementSwaps;
        }
    }

    private void nextSwap() {
        if (this.phase == 1) {
            this.phase = 2;
            this.p.removeAndInsert(this.i, this.j);
            this.i = 0;
            this.j = 2;
        } else {
            this.p.swap(this.i, this.j);
            ++this.j;
            if (this.j >= this.p.length()) {
                ++this.i;
                this.j = this.i + 2;
            }
        }
        this.p.swap(this.i, this.j);
        if (this.i == this.p.length() - 3) {
            this.hasMoreElementSwaps = false;
            this.hasMore = this.hasMoreBlocksInserts;
        }
    }

    private void nextBlockInsertion() {
        int s = this.k - this.j + 1;
        if (this.phase == 2) {
            this.phase = 3;
            this.p.swap(this.i, this.j);
            this.nextS = 2;
            this.j = this.p.length() - 2;
            this.k = this.j + 1;
            this.i = this.j - 2;
            this.p.removeAndInsert(this.j, 2, this.i);
            if (this.i == 0) {
                this.hasMoreBlocksInserts = false;
                this.hasMore = this.hasMoreBlocksSwaps;
            }
        } else if (s != this.nextS) {
            this.p.removeAndInsert(this.i, s, this.j);
            this.j = this.p.length() - this.nextS;
            this.i = this.j - this.nextS;
            s = this.nextS;
            this.k = this.j + s - 1;
            this.p.removeAndInsert(this.j, s, this.i);
            if (this.i == 0) {
                this.hasMoreBlocksInserts = false;
                this.hasMore = this.hasMoreBlocksSwaps;
            }
        } else if (this.j > this.i) {
            if (this.i > 0) {
                --this.i;
                this.p.removeAndInsert(this.i, this.i + s);
            } else if (this.j > s) {
                this.p.removeAndInsert(this.i, s, this.j);
                --this.j;
                --this.k;
                this.i = this.j - s;
                this.p.removeAndInsert(this.j, s, this.i);
            } else {
                this.p.removeAndInsert(this.i, s, this.j);
                this.j = 0;
                this.k = s - 1;
                this.i = s + 1;
                this.p.removeAndInsert(this.j, s, this.i);
                if (this.p.length() == s + s + 1) {
                    this.hasMoreBlocksInserts = false;
                    this.hasMore = this.hasMoreBlocksSwaps;
                }
            }
        } else if (this.i < this.p.length() - s) {
            this.p.removeAndInsert(this.i + s, this.i);
            ++this.i;
        } else {
            this.p.removeAndInsert(this.i, s, this.j);
            ++this.j;
            ++this.k;
            this.i = this.j + s + 1;
            this.p.removeAndInsert(this.j, s, this.i);
            if (this.i == this.p.length() - s) {
                ++this.nextS;
            }
        }
    }

    private void nextBlockSwap() {
        if (this.phase == 3) {
            this.phase = 4;
            this.p.removeAndInsert(this.i, this.k - this.j + 1, this.j);
            this.h = 0;
            this.i = 0;
            this.j = 2;
            this.k = 3;
        } else {
            this.p.swapBlocks(this.h, this.h + this.k - this.j, this.k - this.i + this.h, this.k);
            ++this.k;
            if (this.k >= this.p.length()) {
                ++this.j;
                if (this.j > this.p.length() - 1 || this.h == this.i && this.j == this.p.length() - 1) {
                    ++this.i;
                    if (this.i > this.p.length() - 3) {
                        ++this.h;
                        this.i = this.h;
                        this.j = this.i + 2;
                        this.k = this.j + 1;
                    } else {
                        this.k = this.j = this.i + 2;
                    }
                } else {
                    this.k = this.h == this.i ? this.j + 1 : this.j;
                }
            }
        }
        this.p.swapBlocks(this.h, this.i, this.j, this.k);
        if (this.h == this.p.length() - 4 && this.h != this.i) {
            this.hasMore = false;
            this.hasMoreBlocksSwaps = false;
        }
    }
}

