/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.IterableMutationOperator;
import org.cicirello.search.operators.MutationIterator;
import org.cicirello.search.operators.UndoableMutationOperator;
import org.cicirello.search.operators.permutations.BlockInterchangeIterator;

public class BlockInterchangeMutation
implements UndoableMutationOperator<Permutation>,
IterableMutationOperator<Permutation> {
    private final int[] indexes = new int[4];

    @Override
    public final void mutate(Permutation c) {
        if (c.length() >= 2) {
            this.generateIndexes(c.length(), this.indexes);
            c.swapBlocks(this.indexes[0], this.indexes[1], this.indexes[2], this.indexes[3]);
        }
    }

    @Override
    public final void undo(Permutation c) {
        if (c.length() >= 2) {
            c.swapBlocks(this.indexes[0], this.indexes[0] + this.indexes[3] - this.indexes[2], this.indexes[3] - this.indexes[1] + this.indexes[0], this.indexes[3]);
        }
    }

    @Override
    public BlockInterchangeMutation split() {
        return new BlockInterchangeMutation();
    }

    @Override
    public MutationIterator iterator(Permutation p) {
        return new BlockInterchangeIterator(p);
    }

    void generateIndexes(int n, int[] indexes) {
        RandomIndexer.sampleInsertion((int)(n + 2), (int)4, (int[])indexes);
        if (indexes[3] == n) {
            indexes[3] = indexes[2];
            indexes[2] = indexes[1];
            indexes[1] = indexes[0];
        } else if (indexes[2] == n) {
            indexes[3] = indexes[2] = indexes[1];
            indexes[1] = indexes[0];
        } else if (indexes[3] == n + 1) {
            indexes[3] = indexes[2];
        }
    }
}

