/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import java.util.concurrent.ThreadLocalRandom;
import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.UndoableMutationOperator;

public final class CycleAlphaMutation
implements UndoableMutationOperator<Permutation> {
    private int[] indexes;
    private final double logAlpha;
    private final double alpha;
    private int lastN;
    private double term;

    public CycleAlphaMutation(double alpha) {
        if (alpha <= 0.0 || alpha >= 1.0) {
            throw new IllegalArgumentException("alpha is outside allowed range");
        }
        this.logAlpha = Math.log(alpha);
        this.alpha = alpha;
    }

    @Override
    public final void mutate(Permutation c) {
        if (c.length() >= 2) {
            this.indexes = RandomIndexer.sample((int)c.length(), (int)this.computeK(c.length(), ThreadLocalRandom.current().nextDouble()), (int[])null);
            if (this.indexes.length > 2) {
                for (int j = this.indexes.length - 1; j > 0; --j) {
                    int i = RandomIndexer.nextInt((int)(j + 1));
                    if (i == j) continue;
                    int temp = this.indexes[i];
                    this.indexes[i] = this.indexes[j];
                    this.indexes[j] = temp;
                }
            }
            c.cycle(this.indexes);
        }
    }

    @Override
    public final void undo(Permutation c) {
        if (c.length() >= 2) {
            if (this.indexes.length > 2) {
                int i = 0;
                for (int j = this.indexes.length - 1; i < j; ++i, --j) {
                    int temp = this.indexes[i];
                    this.indexes[i] = this.indexes[j];
                    this.indexes[j] = temp;
                }
            }
            c.cycle(this.indexes);
        }
    }

    @Override
    public CycleAlphaMutation split() {
        return new CycleAlphaMutation(this.alpha);
    }

    final int computeK(int n, double u) {
        int k;
        if (n != this.lastN) {
            this.term = 1.0 - Math.pow(this.alpha, n - 1);
            this.lastN = n;
        }
        return (k = (int)(Math.log(1.0 - u * this.term) / this.logAlpha) + 2) > n ? n : k;
    }
}

