/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.UndoableMutationOperator;

public final class CycleMutation
implements UndoableMutationOperator<Permutation> {
    private int[] indexes;
    private final int bound;

    public CycleMutation(int kmax) {
        if (kmax < 2) {
            throw new IllegalArgumentException("kmax too low");
        }
        this.bound = kmax - 1;
    }

    @Override
    public final void mutate(Permutation c) {
        if (c.length() >= 2) {
            this.indexes = RandomIndexer.sample((int)c.length(), (int)(2 + RandomIndexer.nextInt((int)(this.bound < c.length() ? this.bound : c.length() - 1))), (int[])null);
            if (this.indexes.length > 2) {
                for (int j = this.indexes.length - 1; j > 0; --j) {
                    int i = RandomIndexer.nextInt((int)(j + 1));
                    if (i == j) continue;
                    int temp = this.indexes[i];
                    this.indexes[i] = this.indexes[j];
                    this.indexes[j] = temp;
                }
            }
            c.cycle(this.indexes);
        }
    }

    @Override
    public final void undo(Permutation c) {
        if (c.length() >= 2) {
            if (this.indexes.length > 2) {
                int i = 0;
                for (int j = this.indexes.length - 1; i < j; ++i, --j) {
                    int temp = this.indexes[i];
                    this.indexes[i] = this.indexes[j];
                    this.indexes[j] = temp;
                }
            }
            c.cycle(this.indexes);
        }
    }

    @Override
    public CycleMutation split() {
        return new CycleMutation(this.bound + 1);
    }
}

