/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.CrossoverOperator;

public final class PartiallyMatchedCrossover
implements CrossoverOperator<Permutation> {
    @Override
    public void cross(Permutation c1, Permutation c2) {
        this.internalCross(c1, c2, RandomIndexer.nextInt((int)c1.length()), RandomIndexer.nextInt((int)c1.length()));
    }

    @Override
    public PartiallyMatchedCrossover split() {
        return this;
    }

    final void internalCross(Permutation c1, Permutation c2, int i, int j) {
        if (j < i) {
            int temp = i;
            i = j;
            j = temp;
        }
        int[] inv1 = c1.getInverse();
        int[] inv2 = c2.getInverse();
        int[] old1 = c1.get(i, j);
        int[] old2 = c2.get(i, j);
        int k = i;
        int h = 0;
        while (k <= j) {
            int g = inv1[old2[h]];
            if (k != g) {
                c1.swap(k, g);
                inv1[c1.get((int)g)] = g;
                inv1[old2[h]] = k;
            }
            if (k != (g = inv2[old1[h]])) {
                c2.swap(k, g);
                inv2[c2.get((int)g)] = g;
                inv2[old1[h]] = k;
            }
            ++k;
            ++h;
        }
    }
}

