/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.IterableMutationOperator;
import org.cicirello.search.operators.MutationIterator;
import org.cicirello.search.operators.UndoableMutationOperator;
import org.cicirello.search.operators.permutations.RotationIterator;

public final class RotationMutation
implements UndoableMutationOperator<Permutation>,
IterableMutationOperator<Permutation> {
    private int r;

    @Override
    public void mutate(Permutation c) {
        if (c.length() > 1) {
            this.r = 1 + RandomIndexer.nextInt((int)(c.length() - 1));
            c.rotate(this.r);
        }
    }

    @Override
    public void undo(Permutation c) {
        if (c.length() > 1) {
            c.rotate(c.length() - this.r);
        }
    }

    @Override
    public RotationMutation split() {
        return new RotationMutation();
    }

    @Override
    public MutationIterator iterator(Permutation p) {
        return new RotationIterator(p);
    }
}

