/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.UndoableMutationOperator;
import org.cicirello.search.operators.permutations.TwoChangeMutation;

public final class ThreeOptMutation
implements UndoableMutationOperator<Permutation> {
    private final int[] indexes = new int[3];
    private int which;
    private int lastRotation;
    private final TwoChangeMutation twoChange = new TwoChangeMutation();

    @Override
    public final void mutate(Permutation c) {
        if (c.length() >= 5) {
            RandomIndexer.nextIntTriple((int)c.length(), (int[])this.indexes, (boolean)true);
            this.which = RandomIndexer.nextBiasedInt((int)4);
            this.threeOrTwoChange(this.indexes, this.which, c);
        } else if (c.length() == 4) {
            this.twoChange.mutate(c);
        }
    }

    @Override
    public final void undo(Permutation c) {
        if (c.length() >= 5) {
            this.undoThreeOrTwoChange(this.indexes, this.which, c);
        } else if (c.length() == 4) {
            this.twoChange.undo(c);
        }
    }

    @Override
    public ThreeOptMutation split() {
        return new ThreeOptMutation();
    }

    void threeOrTwoChange(int[] indexes, int which, Permutation c) {
        this.lastRotation = indexes[0];
        c.rotate(this.lastRotation);
        indexes[2] = indexes[2] - indexes[0];
        indexes[1] = indexes[1] - indexes[0];
        indexes[0] = 0;
        if (indexes[2] == 2) {
            c.swap(0, 1);
        } else if (indexes[1] == 1) {
            if (indexes[2] == c.length() - 1) {
                c.swap(0, indexes[2]);
            } else if (which == 0) {
                c.removeAndInsert(1, indexes[2] - 1, 0);
            } else if (c.length() - indexes[2] >= indexes[2] - indexes[1]) {
                c.reverse(0, indexes[2] - 1);
            } else {
                c.reverse(1, indexes[2] - 1);
            }
        } else if (indexes[1] == c.length() - 2) {
            c.swap(indexes[1], indexes[2]);
        } else if (indexes[2] == c.length() - 1) {
            if (which == 0) {
                c.removeAndInsert(indexes[2], 1, indexes[1]);
            } else if (indexes[1] >= indexes[2] - indexes[1]) {
                c.reverse(indexes[1], indexes[2]);
            } else {
                c.reverse(indexes[1], indexes[2] - 1);
            }
        } else if (indexes[2] == indexes[1] + 1) {
            if (which == 0) {
                c.removeAndInsert(indexes[1], 1, 0);
            } else if (indexes[1] <= c.length() - indexes[2]) {
                c.reverse(0, indexes[1]);
            } else {
                c.reverse(indexes[1], c.length() - 1);
            }
        } else if (which == 0) {
            c.removeAndInsert(indexes[1], indexes[2] - indexes[1], 0);
        } else if (which == 1) {
            c.reverse(0, indexes[1] - 1);
            c.reverse(indexes[1], indexes[2] - 1);
        } else if (which == 2) {
            c.reverse(0, indexes[1] - 1);
            c.removeAndInsert(indexes[1], indexes[2] - indexes[1], 0);
        } else {
            c.reverse(indexes[1], indexes[2] - 1);
            c.removeAndInsert(indexes[1], indexes[2] - indexes[1], 0);
        }
    }

    void undoThreeOrTwoChange(int[] indexes, int which, Permutation c) {
        if (indexes[2] == 2) {
            c.swap(0, 1);
        } else if (indexes[1] == 1) {
            if (indexes[2] == c.length() - 1) {
                c.swap(0, indexes[2]);
            } else if (which == 0) {
                c.removeAndInsert(0, indexes[2] - 1, 1);
            } else if (c.length() - indexes[2] >= indexes[2] - indexes[1]) {
                c.reverse(0, indexes[2] - 1);
            } else {
                c.reverse(1, indexes[2] - 1);
            }
        } else if (indexes[1] == c.length() - 2) {
            c.swap(indexes[1], indexes[2]);
        } else if (indexes[2] == c.length() - 1) {
            if (which == 0) {
                c.removeAndInsert(indexes[1], 1, indexes[2]);
            } else if (indexes[1] >= indexes[2] - indexes[1]) {
                c.reverse(indexes[1], indexes[2]);
            } else {
                c.reverse(indexes[1], indexes[2] - 1);
            }
        } else if (indexes[2] == indexes[1] + 1) {
            if (which == 0) {
                c.removeAndInsert(0, 1, indexes[1]);
            } else if (indexes[1] <= c.length() - indexes[2]) {
                c.reverse(0, indexes[1]);
            } else {
                c.reverse(indexes[1], c.length() - 1);
            }
        } else if (which == 0) {
            c.removeAndInsert(0, indexes[2] - indexes[1], indexes[1]);
        } else if (which == 1) {
            c.reverse(0, indexes[1] - 1);
            c.reverse(indexes[1], indexes[2] - 1);
        } else if (which == 2) {
            c.removeAndInsert(0, indexes[2] - indexes[1], indexes[1]);
            c.reverse(0, indexes[1] - 1);
        } else {
            c.removeAndInsert(0, indexes[2] - indexes[1], indexes[1]);
            c.reverse(indexes[1], indexes[2] - 1);
        }
        c.rotate(-this.lastRotation);
    }
}

