/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.IterableMutationOperator;
import org.cicirello.search.operators.MutationIterator;
import org.cicirello.search.operators.UndoableMutationOperator;
import org.cicirello.search.operators.permutations.TwoChangeIterator;

public final class TwoChangeMutation
implements UndoableMutationOperator<Permutation>,
IterableMutationOperator<Permutation> {
    private int a;
    private int b;

    @Override
    public final void mutate(Permutation c) {
        if (c.length() >= 4) {
            this.internalMutate(c, RandomIndexer.nextInt((int)c.length()), 1 + RandomIndexer.nextInt((int)(c.length() - 3)));
        }
    }

    @Override
    public final void undo(Permutation c) {
        if (c.length() >= 4) {
            this.internalMutate(c);
        }
    }

    @Override
    public TwoChangeMutation split() {
        return new TwoChangeMutation();
    }

    @Override
    public MutationIterator iterator(Permutation p) {
        return new TwoChangeIterator(p);
    }

    final void internalMutate(Permutation c, int first, int delta) {
        this.b = first + delta;
        if (this.b >= c.length()) {
            this.a = this.b - c.length() + 1;
            this.b = first - 1;
        } else {
            this.a = first;
        }
        this.internalMutate(c);
    }

    private void internalMutate(Permutation c) {
        if (this.b - this.a < c.length() >> 1) {
            c.reverse(this.a, this.b);
        } else {
            int rightCount = c.length() - this.b - 1;
            int i = this.a - 1;
            if (this.a < rightCount) {
                while (i >= 0) {
                    c.swap(i, j);
                    --i;
                    ++j;
                }
                c.reverse(j, c.length() - 1);
            } else if (this.a > rightCount) {
                for (j = this.b + 1; j < c.length(); ++j) {
                    c.swap(i, j);
                    --i;
                }
                c.reverse(0, i);
            } else {
                while (i >= 0) {
                    c.swap(i, j);
                    --i;
                    ++j;
                }
            }
        }
    }
}

