/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.UndoableMutationOperator;

public class UndoableScrambleMutation
implements UndoableMutationOperator<Permutation> {
    private int[] last;
    private final int[] indexes = new int[2];

    @Override
    public final void mutate(Permutation c) {
        if (c.length() >= 2) {
            this.last = c.toArray();
            this.generateIndexes(c.length(), this.indexes);
            c.scramble(this.indexes[0], this.indexes[1]);
        }
    }

    @Override
    public final void undo(Permutation c) {
        if (c.length() >= 2) {
            if (this.indexes[0] < this.indexes[1]) {
                c.apply(perm -> System.arraycopy(this.last, this.indexes[0], perm, this.indexes[0], this.indexes[1] - this.indexes[0] + 1));
            } else {
                c.apply(perm -> System.arraycopy(this.last, this.indexes[1], perm, this.indexes[1], this.indexes[0] - this.indexes[1] + 1));
            }
        }
    }

    @Override
    public UndoableScrambleMutation split() {
        return new UndoableScrambleMutation();
    }

    void generateIndexes(int n, int[] indexes) {
        RandomIndexer.nextIntPair((int)n, (int[])indexes);
    }
}

