/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.MutationOperator;

public final class UniformScrambleMutation
implements MutationOperator<Permutation> {
    private final double u;
    private final boolean guaranteeChange;

    public UniformScrambleMutation(double u) {
        this(u, false);
    }

    public UniformScrambleMutation(double u, boolean guaranteeChange) {
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u must be in [0.0, 1.0].");
        }
        this.u = u;
        this.guaranteeChange = guaranteeChange;
    }

    @Override
    public final void mutate(Permutation c) {
        if (c.length() >= 2) {
            int[] indexes = RandomIndexer.sample((int)c.length(), (double)this.u);
            if (this.guaranteeChange && indexes.length < 2) {
                indexes = RandomIndexer.nextIntPair((int)c.length(), null);
            }
            c.scramble(indexes);
        }
    }

    @Override
    public UniformScrambleMutation split() {
        return new UniformScrambleMutation(this.u, this.guaranteeChange);
    }
}

