/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.MutationIterator;
import org.cicirello.search.operators.permutations.BlockMoveMutation;
import org.cicirello.search.operators.permutations.WindowLimitedBlockMoveIterator;

public final class WindowLimitedBlockMoveMutation
extends BlockMoveMutation {
    private final int limit;

    public WindowLimitedBlockMoveMutation() {
        this(Integer.MAX_VALUE);
    }

    public WindowLimitedBlockMoveMutation(int windowLimit) {
        if (windowLimit <= 0) {
            throw new IllegalArgumentException("window limit must be positive");
        }
        this.limit = windowLimit;
    }

    @Override
    public WindowLimitedBlockMoveMutation split() {
        return new WindowLimitedBlockMoveMutation(this.limit);
    }

    @Override
    public MutationIterator iterator(Permutation p) {
        return new WindowLimitedBlockMoveIterator(p, this.limit);
    }

    @Override
    final void generateIndexes(int n, int[] indexes) {
        if (this.limit >= n) {
            super.generateIndexes(n, indexes);
            return;
        }
        RandomIndexer.nextWindowedIntTriple((int)(n + 1), (int)(this.limit + 1), (int[])indexes, (boolean)true);
        if (indexes[2] == n || indexes[2] - indexes[0] > this.limit) {
            indexes[2] = indexes[1];
        }
    }
}

