/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.MutationIterator;

final class WindowLimitedReversalIterator
implements MutationIterator {
    private boolean rolled;
    private boolean hasMore;
    private final Permutation p;
    private final int w;
    private int i;
    private int j;
    private int u;
    private int v;
    private int x;
    private int y;

    WindowLimitedReversalIterator(Permutation p, int w) {
        this.p = p;
        this.w = w;
        this.hasMore = p.length() >= 2;
    }

    @Override
    public boolean hasNext() {
        return this.hasMore && !this.rolled;
    }

    @Override
    public void nextMutant() {
        if (!this.hasMore) {
            throw new IllegalStateException("no neighbors left");
        }
        if (this.rolled) {
            throw new IllegalStateException("illegal to call nextMutant after calling rollback");
        }
        if (this.i == this.j) {
            if (this.p.length() >= 3 && this.w >= 2) {
                this.j = 2;
                this.v = 2;
            } else {
                this.j = 1;
                this.v = 1;
            }
        } else if (this.u == 0 || this.v == this.p.length() - 1 || this.v - this.u >= this.w - 1) {
            this.p.reverse(this.u, this.v);
            ++this.j;
            if (this.j >= this.p.length()) {
                this.i = 0;
                this.j = 1;
            } else {
                ++this.i;
            }
            this.u = this.i;
            this.v = this.j;
        } else {
            --this.u;
            ++this.v;
        }
        this.p.swap(this.u, this.v);
        if (this.u == this.p.length() - 2) {
            this.hasMore = false;
        }
    }

    @Override
    public void setSavepoint() {
        this.x = this.u;
        this.y = this.v;
    }

    @Override
    public void rollback() {
        if (!this.rolled) {
            this.rolled = true;
            if (this.y == 0) {
                if (this.v > 0) {
                    this.p.reverse(this.u, this.v);
                }
            } else if (this.u != this.x || this.v != this.y) {
                this.p.reverse(this.u, this.v);
                this.p.reverse(this.x, this.y);
            }
        }
    }
}

