/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.MutationIterator;
import org.cicirello.search.operators.permutations.ReversalMutation;
import org.cicirello.search.operators.permutations.WindowLimitedReversalIterator;

public final class WindowLimitedReversalMutation
extends ReversalMutation {
    private final int limit;

    public WindowLimitedReversalMutation() {
        this(Integer.MAX_VALUE);
    }

    public WindowLimitedReversalMutation(int windowLimit) {
        if (windowLimit <= 0) {
            throw new IllegalArgumentException("window limit must be positive");
        }
        this.limit = windowLimit;
    }

    @Override
    public WindowLimitedReversalMutation split() {
        return new WindowLimitedReversalMutation(this.limit);
    }

    @Override
    public MutationIterator iterator(Permutation p) {
        return new WindowLimitedReversalIterator(p, this.limit);
    }

    @Override
    final void generateIndexes(int n, int[] indexes) {
        if (this.limit >= n) {
            super.generateIndexes(n, indexes);
        } else {
            RandomIndexer.nextWindowedIntPair((int)n, (int)this.limit, (int[])indexes);
        }
    }
}

